/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.semantic;

import javax.faces.component.UIComponentBase;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractSemanticComponentBase<T>
extends UIComponentBase
implements ComponentSystemEventListener {
    public abstract Class<T> getRendererCapability();

    public abstract String getRendererType(T var1);

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        Class<T> rendererCapability = this.getRendererCapability();
        T container = this.findParentImplementing(rendererCapability);
        if (container == null) {
            throw new IllegalArgumentException("Semantic component must be nested within the top-level component");
        }
        String rendererType = this.getRendererType(container);
        if (rendererType != null) {
            this.setRendererType(rendererType);
        }
    }

    private T findParentImplementing(Class<T> type) {
        for (AbstractSemanticComponentBase current = this; current != null; current = current.getParent()) {
            if (!type.isAssignableFrom(((Object)((Object)current)).getClass())) continue;
            return (T)((Object)current);
        }
        return null;
    }
}

