/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.bootstrap.function;

import java.text.MessageFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.bootstrap.javascript.BootstrapJSPlugin;
import org.richfaces.function.RichFunction;

class BootstrapOperation {
    private static String CALL = "jQuery('{0}').{1}('{2}')";
    private static String ESCAPED_CALL = CALL.replace("'", "''");
    private FacesContext facesContext;
    private UIComponent component;
    private String operation;

    public BootstrapOperation(FacesContext facesContext, UIComponent component, String operation) {
        this.facesContext = facesContext;
        this.component = component;
        this.operation = operation;
    }

    public String getClientSideCall() {
        String pluginName = this.getPluginName();
        String escapedClientId = RichFunction.jQuerySelector((FacesContext)this.facesContext, (UIComponent)this.component);
        return MessageFormat.format(ESCAPED_CALL, escapedClientId, pluginName, this.operation);
    }

    public void verifyComponent(Class<?> type) {
        if (this.component == null) {
            throw new IllegalArgumentException("no such target component with identified was found");
        }
        if (this.component.getClass().isInstance(type)) {
            throw new IllegalArgumentException("the target component " + this.component + " is not " + type.getName());
        }
    }

    private String getPluginName() {
        BootstrapJSPlugin bootstrapPlugin = this.component.getClass().getSuperclass().getAnnotation(BootstrapJSPlugin.class);
        if (bootstrapPlugin == null) {
            throw new IllegalArgumentException("given component does not have Bootstrap JavaScript plugin binding defined");
        }
        return bootstrapPlugin.name();
    }
}

