/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.ext.xml.XmlRepresentation;
import org.restlet.ext.xml.internal.AbstractXmlReader;
import org.restlet.ext.xml.internal.ContextResolver;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRepresentation
extends WriterRepresentation {
    private volatile ErrorListener errorListener;
    private volatile Map<String, String> outputProperties;
    private volatile Map<String, Object> parameters;
    private volatile Representation sourceRepresentation;
    private volatile Templates templates;
    private volatile Representation transformSheet;
    private volatile URIResolver uriResolver;

    public static SAXSource toSaxSource(Representation representation) throws IOException {
        SAXSource result = null;
        if (representation instanceof XmlRepresentation) {
            result = ((XmlRepresentation)representation).getSaxSource();
        } else if (representation instanceof TransformRepresentation) {
            final TransformRepresentation source = (TransformRepresentation)representation;
            AbstractXmlReader reader = new AbstractXmlReader(){

                public void parse(InputSource input) throws IOException, SAXException {
                    try {
                        source.getTransformer().transform(source.getSaxSource(), new SAXResult(this.getContentHandler()));
                    }
                    catch (TransformerException te) {
                        throw new IOException("Transformer exception. " + te.getMessage());
                    }
                }

                public void parse(String systemId) throws IOException, SAXException {
                    throw new IllegalStateException("Not implemented");
                }
            };
            result = new SAXSource(reader, null);
        } else {
            result = new SAXSource(new InputSource(representation.getStream()));
        }
        if (representation.getLocationRef() != null) {
            result.setSystemId(representation.getLocationRef().getTargetRef().toString());
        }
        return result;
    }

    public TransformRepresentation(Context context, Representation source, Representation transformSheet) {
        this((URIResolver)(context == null ? null : new ContextResolver(context)), source, transformSheet);
    }

    public TransformRepresentation(Representation source, Representation transformSheet) {
        this((URIResolver)null, source, transformSheet);
    }

    public TransformRepresentation(URIResolver uriResolver, Representation source, Representation transformSheet) {
        this(uriResolver, source, transformSheet, null);
    }

    private TransformRepresentation(URIResolver uriResolver, Representation source, Representation transformSheet, Templates templates) {
        super(null);
        this.sourceRepresentation = source;
        this.templates = templates;
        this.transformSheet = transformSheet;
        this.uriResolver = uriResolver;
        this.parameters = new HashMap<String, Object>();
        this.outputProperties = new HashMap<String, String>();
        this.errorListener = null;
    }

    public TransformRepresentation(URIResolver uriResolver, Representation source, Templates templates) {
        this(uriResolver, source, null, templates);
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public SAXSource getSaxSource() throws IOException {
        return TransformRepresentation.toSaxSource(this.getSourceRepresentation());
    }

    private SAXTransformerFactory getSaxTransformerFactory() {
        SAXTransformerFactory result = (SAXTransformerFactory)TransformerFactory.newInstance();
        return result;
    }

    public Representation getSourceRepresentation() {
        return this.sourceRepresentation;
    }

    public Templates getTemplates() throws IOException {
        if (this.templates == null && this.getTransformSheet() != null) {
            try {
                StreamSource transformSource = new StreamSource(this.getTransformSheet().getStream());
                if (this.getTransformSheet().getLocationRef() != null) {
                    transformSource.setSystemId(this.getTransformSheet().getLocationRef().getTargetRef().toString());
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                if (this.getUriResolver() != null) {
                    transformerFactory.setURIResolver(this.getUriResolver());
                }
                this.templates = transformerFactory.newTemplates(transformSource);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return this.templates;
    }

    public Transformer getTransformer() throws IOException {
        Transformer result = null;
        try {
            Templates templates = this.getTemplates();
            if (templates != null) {
                result = templates.newTransformer();
                if (this.getErrorListener() != null) {
                    result.setErrorListener(this.getErrorListener());
                }
                if (this.getUriResolver() != null) {
                    result.setURIResolver(this.getUriResolver());
                }
                for (String name : this.getParameters().keySet()) {
                    result.setParameter(name, this.getParameters().get(name));
                }
                for (String name : this.getOutputProperties().keySet()) {
                    result.setOutputProperty(name, this.getOutputProperties().get(name));
                }
            }
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException("Transformer configuration exception. " + tce.getMessage());
        }
        catch (TransformerFactoryConfigurationError tfce) {
            throw new IOException("Transformer factory configuration exception. " + tfce.getMessage());
        }
        return result;
    }

    public TransformerHandler getTransformerHandler() throws IOException {
        TransformerHandler result = null;
        Templates templates = this.getTemplates();
        if (templates != null) {
            try {
                result = this.getSaxTransformerFactory().newTransformerHandler(templates);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return result;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public URIResolver getUriResolver() {
        return this.uriResolver;
    }

    public XMLFilter getXmlFilter() throws IOException {
        XMLFilter result = null;
        Templates templates = this.getTemplates();
        if (templates != null) {
            try {
                result = this.getSaxTransformerFactory().newXMLFilter(templates);
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
        }
        return result;
    }

    public void release() {
        if (this.sourceRepresentation != null) {
            this.sourceRepresentation.release();
            this.sourceRepresentation = null;
        }
        if (this.templates != null) {
            this.templates = null;
        }
        if (this.transformSheet != null) {
            this.transformSheet.release();
            this.transformSheet = null;
        }
        if (this.uriResolver != null) {
            this.uriResolver = null;
        }
        super.release();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setOutputProperties(Map<String, String> outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setSourceRepresentation(Representation source) {
        this.sourceRepresentation = source;
    }

    public void setTemplates(Templates templates) {
        this.templates = templates;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void transform(Source source, Result result) throws IOException {
        if (this.getTransformer() == null) {
            Context.getCurrentLogger().warning("Unable to apply the transformation. No transformer found!");
        } else {
            try {
                this.getTransformer().transform(source, result);
            }
            catch (TransformerException te) {
                throw new IOException("Transformer exception. " + te.getMessage());
            }
        }
    }

    public void write(Result result) throws IOException {
        this.transform(this.getSaxSource(), result);
    }

    public void write(Writer writer) throws IOException {
        this.write(new StreamResult(writer));
    }
}

