/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RouteList
extends WrapperList<Route> {
    private int lastIndex = -1;

    public RouteList() {
        super(new CopyOnWriteArrayList());
    }

    public RouteList(List<Route> delegate) {
        super(new CopyOnWriteArrayList<Route>(delegate));
    }

    public Route getBest(Request request, Response response, float requiredScore) {
        Route result = null;
        float bestScore = 0.0f;
        for (Route current : this) {
            float score = current.score(request, response);
            if (!(score > bestScore) || !(score >= requiredScore)) continue;
            bestScore = score;
            result = current;
        }
        return result;
    }

    public Route getFirst(Request request, Response response, float requiredScore) {
        for (Route current : this) {
            if (!(current.score(request, response) >= requiredScore)) continue;
            return current;
        }
        return null;
    }

    public Route getLast(Request request, Response response, float requiredScore) {
        Route[] routes = (Route[])this.toArray();
        for (int j = routes.length - 1; j >= 0; --j) {
            if (!(routes[j].score(request, response) >= requiredScore)) continue;
            return routes[j];
        }
        return null;
    }

    public Route getNext(Request request, Response response, float requiredScore) {
        Route[] routes = (Route[])this.toArray();
        int initialIndex = this.lastIndex++;
        while (initialIndex != this.lastIndex) {
            if (this.lastIndex >= routes.length) {
                this.lastIndex = 0;
            }
            if (routes[this.lastIndex].score(request, response) >= requiredScore) {
                return routes[this.lastIndex];
            }
            ++this.lastIndex;
        }
        return null;
    }

    public Route getRandom(Request request, Response response, float requiredScore) {
        int j;
        Route[] routes = (Route[])this.toArray();
        if (routes[j = new Random().nextInt(routes.length)].score(request, response) >= requiredScore) {
            return routes[j];
        }
        int initialIndex = j++;
        while (initialIndex != j) {
            if (j == routes.length) {
                j = 0;
            }
            if (routes[j].score(request, response) >= requiredScore) {
                return routes[j];
            }
            ++j;
        }
        return null;
    }

    public void removeAll(Restlet target) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (((Route)this.get(i)).getNext() != target) continue;
            this.remove(i);
        }
    }

    public RouteList subList(int fromIndex, int toIndex) {
        return new RouteList(this.getDelegate().subList(fromIndex, toIndex));
    }
}

