/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.WrapperList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RouteList
extends WrapperList<Route> {
    private int lastIndex = -1;

    public RouteList() {
        this((List<Route>)null);
    }

    public RouteList(int initialCapacity) {
        this((List<Route>)new ArrayList<Route>(initialCapacity));
    }

    public RouteList(List<Route> delegate) {
        super(delegate);
    }

    public synchronized Route getBest(Request request, Response response, float requiredScore) {
        Route result = null;
        float bestScore = 0.0f;
        for (Route current : this) {
            float score = current.score(request, response);
            if (!(score > bestScore) || !(score >= requiredScore)) continue;
            bestScore = score;
            result = current;
        }
        return result;
    }

    public synchronized Route getFirst(Request request, Response response, float requiredScore) {
        for (Route current : this) {
            if (!(current.score(request, response) >= requiredScore)) continue;
            return current;
        }
        return null;
    }

    public synchronized Route getLast(Request request, Response response, float requiredScore) {
        for (int j = this.size() - 1; j >= 0; --j) {
            if (!(((Route)this.get(j)).score(request, response) >= requiredScore)) continue;
            return (Route)this.get(j);
        }
        return null;
    }

    public synchronized Route getNext(Request request, Response response, float requiredScore) {
        int initialIndex = this.lastIndex++;
        while (initialIndex != this.lastIndex) {
            if (this.lastIndex == this.size()) {
                this.lastIndex = 0;
            }
            if (((Route)this.get(this.lastIndex)).score(request, response) >= requiredScore) {
                return (Route)this.get(this.lastIndex);
            }
            ++this.lastIndex;
        }
        return null;
    }

    public synchronized Route getRandom(Request request, Response response, float requiredScore) {
        int j = new Random().nextInt(this.size());
        if (((Route)this.get(j)).score(request, response) >= requiredScore) {
            return (Route)this.get(j);
        }
        int initialIndex = j++;
        while (initialIndex != j) {
            if (j == this.size()) {
                j = 0;
            }
            if (((Route)this.get(j)).score(request, response) >= requiredScore) {
                return (Route)this.get(j);
            }
            ++j;
        }
        return null;
    }

    public void removeAll(Restlet target) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (((Route)this.get(i)).getNext() != target) continue;
            this.remove(i);
        }
    }

    public synchronized RouteList subList(int fromIndex, int toIndex) {
        return new RouteList(this.getDelegate().subList(fromIndex, toIndex));
    }
}

