/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.restlet.data.CharacterSet;
import org.restlet.resource.Representation;

public final class ByteUtils {
    public static ReadableByteChannel getChannel(InputStream inputStream) throws IOException {
        return inputStream != null ? Channels.newChannel(inputStream) : null;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) throws IOException {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        final Pipe pipe = Pipe.open();
        Thread writer = new Thread(){

            public void run() {
                try {
                    Pipe.SinkChannel wbc = pipe.sink();
                    representation.write(wbc);
                    wbc.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        };
        writer.start();
        return pipe.source();
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) throws IOException {
        return readableChannel != null ? Channels.newInputStream(readableChannel) : null;
    }

    public static InputStream getStream(final Representation representation) throws IOException {
        if (representation != null) {
            final PipeStream pipe = new PipeStream();
            Thread writer = new Thread(){

                public void run() {
                    try {
                        OutputStream os = pipe.getOutputStream();
                        representation.write(os);
                        os.write(-1);
                        os.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            };
            writer.start();
            return pipe.getInputStream();
        }
        return null;
    }

    public static OutputStream getStream(WritableByteChannel writableChannel) {
        return writableChannel != null ? Channels.newOutputStream(writableChannel) : null;
    }

    public static String toString(InputStream inputStream) {
        return ByteUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                StringBuilder sb = new StringBuilder();
                InputStreamReader isr = null;
                isr = characterSet != null ? new InputStreamReader(inputStream, characterSet.getName()) : new InputStreamReader(inputStream);
                BufferedReader br = new BufferedReader(isr);
                int nextByte = br.read();
                while (nextByte != -1) {
                    sb.append((char)nextByte);
                    nextByte = br.read();
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void write(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            ByteUtils.write(Channels.newInputStream(readableChannel), Channels.newOutputStream(writableChannel));
        }
    }

    private ByteUtils() {
    }

    private static final class PipeStream {
        private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

        public InputStream getInputStream() {
            return new InputStream(){
                private boolean endReached = false;

                public int read() throws IOException {
                    try {
                        if (this.endReached) {
                            return -1;
                        }
                        int value = (Integer)PipeStream.this.queue.take();
                        this.endReached = value == -1;
                        return value;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }

        public OutputStream getOutputStream() {
            return new OutputStream(){

                public void write(int b) throws IOException {
                    try {
                        PipeStream.this.queue.put(b);
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("Interruption occurred while writing in the queue");
                    }
                }
            };
        }
    }
}

