/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.data.Response;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

public class TransformRepresentation
extends OutputRepresentation {
    private Representation source;
    private Transformer transformer;
    private Representation transformSheet;
    private URIResolver uriResolver;

    public TransformRepresentation(Context context, Representation source, Representation transformSheet) {
        super(null);
        this.source = source;
        this.transformSheet = transformSheet;
        this.uriResolver = context == null ? null : new ContextResolver(context);
    }

    public Representation getSourceRepresentation() {
        return this.source;
    }

    public Transformer getTransformer() throws IOException {
        if (this.transformer == null) {
            try {
                StreamSource transformSheet = new StreamSource(this.getTransformSheet().getStream());
                this.transformer = TransformerFactory.newInstance().newTransformer(transformSheet);
                this.transformer.setURIResolver(this.getURIResolver());
            }
            catch (TransformerConfigurationException tce) {
                throw new IOException("Transformer configuration exception. " + tce.getMessage());
            }
            catch (TransformerFactoryConfigurationError tfce) {
                throw new IOException("Transformer factory configuration exception. " + tfce.getMessage());
            }
        }
        return this.transformer;
    }

    public Representation getTransformSheet() {
        return this.transformSheet;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setTransformSheet(Representation transformSheet) {
        this.transformSheet = transformSheet;
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            StreamSource sourceDocument = new StreamSource(this.getSourceRepresentation().getStream());
            StreamResult resultDocument = new StreamResult(outputStream);
            this.getTransformer().transform(sourceDocument, resultDocument);
        }
        catch (TransformerException te) {
            throw new IOException("Transformer exception. " + te.getMessage());
        }
    }

    private static final class ContextResolver
    implements URIResolver {
        private Context context;

        public ContextResolver(Context context) {
            this.context = context;
        }

        public Source resolve(String href, String base) throws TransformerException {
            StreamSource result = null;
            if (this.context != null) {
                Reference targetRef = null;
                if (base != null) {
                    Reference baseRef = new Reference(base);
                    targetRef = new Reference(baseRef, href);
                } else {
                    targetRef = new Reference(href);
                }
                Response response = this.context.getDispatcher().get(targetRef.toString());
                if (response.getStatus().isSuccess() && response.isEntityAvailable()) {
                    try {
                        result = new StreamSource(response.getEntity().getStream());
                    }
                    catch (IOException e) {
                        this.context.getLogger().log(Level.WARNING, "I/O error while getting the response stream", e);
                    }
                }
            }
            return result;
        }
    }
}

