/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.restlet.data.CharacterSet;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.resource.StreamRepresentation;

public class StringRepresentation
extends StreamRepresentation {
    private CharSequence text;

    public StringRepresentation(CharSequence text) {
        this(text, MediaType.TEXT_PLAIN);
    }

    public StringRepresentation(CharSequence text, Language language) {
        this(text, MediaType.TEXT_PLAIN, language);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType) {
        this(text, mediaType, null);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType, Language language) {
        this(text, mediaType, language, CharacterSet.ISO_8859_1);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType, Language language, CharacterSet characterSet) {
        super(mediaType);
        this.text = text;
        this.setMediaType(mediaType);
        if (language != null) {
            this.getLanguages().add(language);
        }
        this.setCharacterSet(characterSet);
        this.updateSize();
    }

    public InputStream getStream() throws IOException {
        if (this.getText() != null) {
            if (this.getCharacterSet() != null) {
                return new ByteArrayInputStream(this.getText().getBytes(this.getCharacterSet().getName()));
            }
            return new ByteArrayInputStream(this.getText().getBytes());
        }
        return null;
    }

    public String getText() {
        return this.text == null ? null : ((Object)this.text).toString();
    }

    public void setText(String text) {
        this.text = text;
        this.updateSize();
    }

    protected void updateSize() {
        block5: {
            if (this.getText() != null) {
                try {
                    if (this.getCharacterSet() != null) {
                        this.setSize(this.getText().getBytes(this.getCharacterSet().getName()).length);
                        break block5;
                    }
                    this.setSize(this.getText().getBytes().length);
                }
                catch (UnsupportedEncodingException e) {
                    Logger.getLogger(StringRepresentation.class.getCanonicalName());
                    this.setSize(-1L);
                }
            } else {
                this.setSize(-1L);
            }
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.getText() != null) {
            OutputStreamWriter osw = null;
            osw = this.getCharacterSet() != null ? new OutputStreamWriter(outputStream, this.getCharacterSet().getName()) : new OutputStreamWriter(outputStream);
            osw.write(this.getText());
            osw.flush();
        }
    }
}

