/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.Dimension;
import org.restlet.data.Language;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.util.Series;
import org.restlet.util.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private Context context;
    private Logger logger;
    private boolean negotiateContent;
    private Request request;
    private Response response;
    private List<Variant> variants;

    public Resource() {
    }

    public Resource(Context context, Request request, Response response) {
        this.init(context, request, response);
    }

    public boolean allowDelete() {
        return false;
    }

    public boolean allowGet() {
        return true;
    }

    public boolean allowPost() {
        return false;
    }

    public boolean allowPut() {
        return false;
    }

    public void delete() {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public Reference generateRef(String uriTemplate) {
        Template tplt = new Template(this.getLogger(), uriTemplate);
        return new Reference(tplt.format(this.getRequest(), this.getResponse()));
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = new Context(this.getClass().getCanonicalName());
        }
        return this.context;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.getContext().getLogger();
        }
        return this.logger;
    }

    public Representation getPreferredRepresentation() {
        return this.getRepresentation(this.getPreferredVariant());
    }

    public Variant getPreferredVariant() {
        Variant result = null;
        List<Variant> variants = this.getVariants();
        if (variants != null && !variants.isEmpty()) {
            Language language = null;
            Object app = this.getContext().getAttributes().get("org.restlet.application");
            if (app instanceof Application) {
                language = ((Application)app).getMetadataService().getDefaultLanguage();
            }
            result = this.getRequest().getClientInfo().getPreferredVariant(variants, language);
        }
        return result;
    }

    public Representation getRepresentation(Variant variant) {
        Representation result = null;
        if (variant instanceof Representation) {
            result = (Representation)variant;
        }
        return result;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public List<Variant> getVariants() {
        if (this.variants == null) {
            this.variants = new ArrayList<Variant>();
        }
        return this.variants;
    }

    public void handleDelete() {
        boolean bContinue = true;
        if (this.getRequest().getConditions().hasSome()) {
            Status status;
            Variant preferredVariant = null;
            if (this.isNegotiateContent()) {
                preferredVariant = this.getPreferredVariant();
            } else {
                List<Variant> variants = this.getVariants();
                if (variants.size() == 1) {
                    preferredVariant = variants.get(0);
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED);
                    bContinue = false;
                }
            }
            if (bContinue && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), preferredVariant)) != null) {
                this.getResponse().setStatus(status);
                bContinue = false;
            }
        }
        if (bContinue) {
            this.delete();
        }
    }

    public void handleGet() {
        Status status;
        Variant selectedVariant = null;
        List<Variant> variants = this.getVariants();
        if (variants == null || variants.isEmpty()) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else if (this.isNegotiateContent()) {
            Variant preferredVariant = this.getPreferredVariant();
            this.getResponse().getDimensions().clear();
            this.getResponse().getDimensions().add(Dimension.CHARACTER_SET);
            this.getResponse().getDimensions().add(Dimension.ENCODING);
            this.getResponse().getDimensions().add(Dimension.LANGUAGE);
            this.getResponse().getDimensions().add(Dimension.MEDIA_TYPE);
            if (preferredVariant == null) {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE);
                ReferenceList refs = new ReferenceList(variants.size());
                for (Variant variant : variants) {
                    if (variant.getIdentifier() == null) continue;
                    refs.add(variant.getIdentifier());
                }
                this.getResponse().setEntity(refs.getTextRepresentation());
            } else {
                this.getResponse().setEntity(this.getRepresentation(preferredVariant));
                selectedVariant = preferredVariant;
            }
            selectedVariant = this.getResponse().getEntity();
        } else if (variants.size() == 1) {
            this.getResponse().setEntity(variants.get(0));
            selectedVariant = this.getResponse().getEntity();
        } else {
            ReferenceList variantRefs = new ReferenceList();
            for (Variant variant : variants) {
                if (variant.getIdentifier() != null) {
                    variantRefs.add(variant.getIdentifier());
                    continue;
                }
                this.getLogger().warning("A resource with multiple variants should provide and identifier for each variants when content negotiation is turned off");
            }
            if (variantRefs.size() > 0) {
                this.getResponse().setStatus(Status.REDIRECTION_MULTIPLE_CHOICES);
                this.getResponse().setEntity(variantRefs.getTextRepresentation());
            } else {
                this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        if (this.getRequest().getConditions().hasSome() && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), selectedVariant)) != null) {
            this.getResponse().setStatus(status);
            this.getResponse().setEntity(null);
        }
    }

    public void handleHead() {
        this.handleGet();
    }

    public void handleOptions() {
        this.updateAllowedMethods();
        this.getResponse().setStatus(Status.SUCCESS_OK);
    }

    public void handlePost() {
        if (this.getRequest().isEntityAvailable()) {
            this.post(this.getRequest().getEntity());
        } else {
            this.getResponse().setStatus(new Status(Status.CLIENT_ERROR_BAD_REQUEST, "Missing request entity"));
        }
    }

    public void handlePut() {
        Series headers;
        Object oHeaders;
        boolean bContinue = true;
        if (this.getRequest().getConditions().hasSome()) {
            Status status;
            Variant preferredVariant = null;
            if (this.isNegotiateContent()) {
                preferredVariant = this.getPreferredVariant();
            } else {
                List<Variant> variants = this.getVariants();
                if (variants.size() == 1) {
                    preferredVariant = variants.get(0);
                } else {
                    this.getResponse().setStatus(Status.CLIENT_ERROR_PRECONDITION_FAILED);
                    bContinue = false;
                }
            }
            if (bContinue && (status = this.getRequest().getConditions().getStatus(this.getRequest().getMethod(), preferredVariant)) != null) {
                this.getResponse().setStatus(status);
                bContinue = false;
            }
        }
        if (bContinue && (oHeaders = this.getRequest().getAttributes().get("org.restlet.http.headers")) != null && (headers = (Series)oHeaders).getFirst("Content-Range", true) != null) {
            this.getResponse().setStatus(new Status(Status.SERVER_ERROR_NOT_IMPLEMENTED, "the Content-Range header is not understood"));
            bContinue = false;
        }
        if (bContinue) {
            if (this.getRequest().isEntityAvailable()) {
                this.put(this.getRequest().getEntity());
                this.updateAllowedMethods();
            } else {
                this.getResponse().setStatus(new Status(Status.CLIENT_ERROR_BAD_REQUEST, "Missing request entity"));
            }
        }
    }

    public void init(Context context, Request request, Response response) {
        this.context = context;
        this.logger = context != null ? context.getLogger() : null;
        this.negotiateContent = true;
        this.request = request;
        this.response = response;
        this.variants = null;
    }

    private Object invoke(java.lang.reflect.Method method, Object ... args) {
        Object result = null;
        if (method != null) {
            try {
                result = method.invoke((Object)this, args);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Couldn't invoke the handle method for \"" + method + "\"", e);
            }
        }
        return result;
    }

    public boolean isNegotiateContent() {
        return this.negotiateContent;
    }

    public void post(Representation entity) {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void put(Representation entity) {
        this.getResponse().setStatus(Status.SERVER_ERROR_INTERNAL);
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setNegotiateContent(boolean negotiateContent) {
        this.negotiateContent = negotiateContent;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    private void updateAllowedMethods() {
        Set<Method> allowedMethods = this.getResponse().getAllowedMethods();
        for (java.lang.reflect.Method classMethod : this.getClass().getMethods()) {
            if (!classMethod.getName().startsWith("allow") || classMethod.getParameterTypes().length != 0 || !((Boolean)this.invoke(classMethod, new Object[0])).booleanValue()) continue;
            Method allowedMethod = Method.valueOf(classMethod.getName().substring(5));
            allowedMethods.add(allowedMethod);
        }
    }
}

