/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import org.restlet.data.Form;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaType
extends Metadata {
    public static final MediaType ALL = new MediaType("*/*", "All media");
    public static final MediaType APPLICATION_ALL = new MediaType("application/*", "All application documents");
    public static final MediaType APPLICATION_ATOM_XML = new MediaType("application/atom+xml", "Atom syndication documents");
    public static final MediaType APPLICATION_CAB = new MediaType("application/vnd.ms-cab-compressed", "Microsoft Cabinet archive");
    public static final MediaType APPLICATION_EXCEL = new MediaType("application/vnd.ms-excel", "Microsoft Excel document");
    public static final MediaType APPLICATION_FLASH = new MediaType("application/x-shockwave-flash", "Shockwave Flash object");
    public static final MediaType APPLICATION_GNU_TAR = new MediaType("application/x-gtar", "GNU Tar archive");
    public static final MediaType APPLICATION_GNU_ZIP = new MediaType("application/x-gzip", "GNU Zip archive");
    public static final MediaType APPLICATION_HTTP_COOKIES = new MediaType("application/x-http-cookies", "HTTP cookies");
    public static final MediaType APPLICATION_JAVA_ARCHIVE = new MediaType("application/java-archive", "Java archive");
    public static final MediaType APPLICATION_JAVA_OBJECT = new MediaType("application/x-java-serialized-object", "Java serialized object");
    public static final MediaType APPLICATION_JAVASCRIPT = new MediaType("application/x-javascript", "Javascript document");
    public static final MediaType APPLICATION_JSON = new MediaType("application/json", "JavaScript Object Notation document");
    public static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application/octet-stream", "Raw octet stream");
    public static final MediaType APPLICATION_PDF = new MediaType("application/pdf", "Adobe PDF document");
    public static final MediaType APPLICATION_POSTSCRIPT = new MediaType("application/postscript", "Postscript document");
    public static final MediaType APPLICATION_POWERPOINT = new MediaType("application/vnd.ms-powerpoint", "Microsoft Powerpoint document");
    public static final MediaType APPLICATION_PROJECT = new MediaType("application/vnd.ms-project", "Microsoft Project document");
    public static final MediaType APPLICATION_RDF_XML = new MediaType("application/rdf+xml", "XML serialized Resource Description Framework document");
    public static final MediaType APPLICATION_RTF = new MediaType("application/rtf", "Rich Text Format document");
    public static final MediaType APPLICATION_STUFFIT = new MediaType("application/x-stuffit", "Stuffit archive");
    public static final MediaType APPLICATION_TAR = new MediaType("application/x-tar", "Tar archive");
    public static final MediaType APPLICATION_WORD = new MediaType("application/msword", "Microsoft Word document");
    public static final MediaType APPLICATION_WWW_FORM = new MediaType("application/x-www-form-urlencoded", "Web form (URL encoded)");
    public static final MediaType APPLICATION_XHTML_XML = new MediaType("application/xhtml+xml", "XHTML document");
    public static final MediaType APPLICATION_XML = new MediaType("application/xml", "XML document");
    public static final MediaType APPLICATION_ZIP = new MediaType("application/zip", "Zip archive");
    public static final MediaType AUDIO_ALL = new MediaType("audio/*", "All audios");
    public static final MediaType AUDIO_MPEG = new MediaType("audio/mpeg", "MPEG audio (MP3)");
    public static final MediaType AUDIO_REAL = new MediaType("audio/x-pn-realaudio", "Real audio");
    public static final MediaType AUDIO_WAV = new MediaType("audio/x-wav", "Waveform audio");
    public static final MediaType IMAGE_ALL = new MediaType("image/*", "All images");
    public static final MediaType IMAGE_BMP = new MediaType("image/bmp", "Windows bitmap");
    public static final MediaType IMAGE_GIF = new MediaType("image/gif", "GIF image");
    public static final MediaType IMAGE_ICON = new MediaType("image/x-icon", "Windows icon (Favicon)");
    public static final MediaType IMAGE_JPEG = new MediaType("image/jpeg", "JPEG image");
    public static final MediaType IMAGE_PNG = new MediaType("image/png", "PNG image");
    public static final MediaType IMAGE_SVG = new MediaType("image/svg+xml", "Scalable Vector Graphics");
    public static final MediaType MESSAGE_ALL = new MediaType("message/*", "All messages");
    public static final MediaType MODEL_ALL = new MediaType("model/*", "All models");
    public static final MediaType MULTIPART_ALL = new MediaType("multipart/*", "All multipart data");
    public static final MediaType MULTIPART_FORM_DATA = new MediaType("multipart/form-data", "Multipart form data");
    public static final MediaType TEXT_ALL = new MediaType("text/*", "All texts");
    public static final MediaType TEXT_CALENDAR = new MediaType("text/calendar", "iCalendar event");
    public static final MediaType TEXT_CSS = new MediaType("text/css", "CSS stylesheet");
    public static final MediaType TEXT_HTML = new MediaType("text/html", "HTML document");
    public static final MediaType TEXT_PLAIN = new MediaType("text/plain", "Plain text");
    public static final MediaType TEXT_RDF_N3 = new MediaType("text/rdf+n3", "N3 serialized Resource Description Framework document");
    public static final MediaType TEXT_URI_LIST = new MediaType("text/uri-list", "List of URIs");
    public static final MediaType TEXT_VCARD = new MediaType("text/x-vcard", "vCard");
    public static final MediaType TEXT_XML = new MediaType("text/xml", "XML text");
    public static final MediaType VIDEO_ALL = new MediaType("video/*", "All videos");
    public static final MediaType VIDEO_AVI = new MediaType("video/x-msvideo", "AVI video");
    public static final MediaType VIDEO_MPEG = new MediaType("video/mpeg", "MPEG video");
    public static final MediaType VIDEO_QUICKTIME = new MediaType("video/quicktime", "Quicktime video");
    public static final MediaType VIDEO_WMV = new MediaType("video/x-ms-wmv", "Windows movie");
    private Series<Parameter> parameters;

    public static MediaType valueOf(String name) {
        MediaType result = null;
        if (name != null) {
            result = name.equals(ALL.getName()) ? ALL : (name.equals(APPLICATION_ALL.getName()) ? APPLICATION_ALL : (name.equals(APPLICATION_ATOM_XML.getName()) ? APPLICATION_ATOM_XML : (name.equals(APPLICATION_CAB.getName()) ? APPLICATION_CAB : (name.equals(APPLICATION_EXCEL.getName()) ? APPLICATION_EXCEL : (name.equals(APPLICATION_FLASH.getName()) ? APPLICATION_FLASH : (name.equals(APPLICATION_GNU_TAR.getName()) ? APPLICATION_GNU_TAR : (name.equals(APPLICATION_GNU_ZIP.getName()) ? APPLICATION_GNU_ZIP : (name.equals(APPLICATION_JAVA_ARCHIVE.getName()) ? APPLICATION_JAVA_ARCHIVE : (name.equals(APPLICATION_JAVA_OBJECT.getName()) ? APPLICATION_JAVA_OBJECT : (name.equals(APPLICATION_JAVASCRIPT.getName()) ? APPLICATION_JAVASCRIPT : (name.equals(APPLICATION_JSON.getName()) ? APPLICATION_JSON : (name.equals(APPLICATION_OCTET_STREAM.getName()) ? APPLICATION_OCTET_STREAM : (name.equals(APPLICATION_PDF.getName()) ? APPLICATION_PDF : (name.equals(APPLICATION_POSTSCRIPT.getName()) ? APPLICATION_POSTSCRIPT : (name.equals(APPLICATION_POWERPOINT.getName()) ? APPLICATION_POWERPOINT : (name.equals(APPLICATION_PROJECT.getName()) ? APPLICATION_PROJECT : (name.equals(APPLICATION_RTF.getName()) ? APPLICATION_RTF : (name.equals(APPLICATION_STUFFIT.getName()) ? APPLICATION_STUFFIT : (name.equals(APPLICATION_TAR.getName()) ? APPLICATION_TAR : (name.equals(APPLICATION_WORD.getName()) ? APPLICATION_WORD : (name.equals(APPLICATION_WWW_FORM.getName()) ? APPLICATION_WWW_FORM : (name.equals(APPLICATION_XHTML_XML.getName()) ? APPLICATION_XHTML_XML : (name.equals(APPLICATION_XML.getName()) ? APPLICATION_XML : (name.equals(APPLICATION_ZIP.getName()) ? APPLICATION_ZIP : (name.equals(AUDIO_ALL.getName()) ? AUDIO_ALL : (name.equals(AUDIO_MPEG.getName()) ? AUDIO_MPEG : (name.equals(AUDIO_REAL.getName()) ? AUDIO_REAL : (name.equals(AUDIO_WAV.getName()) ? AUDIO_WAV : (name.equals(IMAGE_ALL.getName()) ? IMAGE_ALL : (name.equals(IMAGE_BMP.getName()) ? IMAGE_BMP : (name.equals(IMAGE_GIF.getName()) ? IMAGE_GIF : (name.equals(IMAGE_ICON.getName()) ? IMAGE_ICON : (name.equals(IMAGE_JPEG.getName()) ? IMAGE_JPEG : (name.equals(IMAGE_PNG.getName()) ? IMAGE_PNG : (name.equals(IMAGE_SVG.getName()) ? IMAGE_SVG : (name.equals(MESSAGE_ALL.getName()) ? MESSAGE_ALL : (name.equals(MODEL_ALL.getName()) ? MODEL_ALL : (name.equals(MESSAGE_ALL.getName()) ? MESSAGE_ALL : (name.equals(MULTIPART_ALL.getName()) ? MULTIPART_ALL : (name.equals(MULTIPART_FORM_DATA.getName()) ? MULTIPART_FORM_DATA : (name.equals(TEXT_ALL.getName()) ? TEXT_ALL : (name.equals(TEXT_CALENDAR.getName()) ? TEXT_CALENDAR : (name.equals(TEXT_CSS.getName()) ? TEXT_CSS : (name.equals(TEXT_HTML.getName()) ? TEXT_HTML : (name.equals(TEXT_PLAIN.getName()) ? TEXT_PLAIN : (name.equals(TEXT_URI_LIST.getName()) ? TEXT_URI_LIST : (name.equals(TEXT_VCARD.getName()) ? TEXT_VCARD : (name.equals(TEXT_XML.getName()) ? TEXT_XML : (name.equals(VIDEO_ALL.getName()) ? VIDEO_ALL : (name.equals(VIDEO_AVI.getName()) ? VIDEO_AVI : (name.equals(VIDEO_MPEG.getName()) ? VIDEO_MPEG : (name.equals(VIDEO_QUICKTIME.getName()) ? VIDEO_QUICKTIME : (name.equals(VIDEO_WMV.getName()) ? VIDEO_WMV : new MediaType(name))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        return result;
    }

    public MediaType(String name) {
        this(name, null, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters) {
        this(name, parameters, "Media type or range of media types");
    }

    public MediaType(String name, Series<Parameter> parameters, String description) {
        super(name == null ? null : name, description);
        this.parameters = parameters;
    }

    public MediaType(String name, String description) {
        this(name, null, description);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean ignoreParameters) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && super.equals(obj) && obj instanceof MediaType && obj != null) {
            MediaType that = (MediaType)obj;
            result = ignoreParameters || this.getParameters().equals(that.getParameters());
        }
        return result;
    }

    public String getMainType() {
        String result = null;
        if (this.getName() != null) {
            int index = this.getName().indexOf(47);
            if (index == -1) {
                index = this.getName().indexOf(59);
            }
            result = index == -1 ? this.getName() : this.getName().substring(0, index);
        }
        return result;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Form();
        }
        return this.parameters;
    }

    public String getSubType() {
        String result = null;
        if (this.getName() != null) {
            int separator;
            int slash = this.getName().indexOf(47);
            result = slash == -1 ? "*" : ((separator = this.getName().indexOf(59)) == -1 ? this.getName().substring(slash + 1) : this.getName().substring(slash + 1, separator));
        }
        return result;
    }

    @Override
    public int hashCode() {
        return Engine.hashCode(super.hashCode(), this.getParameters());
    }

    public boolean includes(MediaType included) {
        boolean result;
        boolean bl = result = this.equals(ALL) || this.equals(included);
        if (!result) {
            result = this.getMainType().equals(included.getMainType()) && (this.getSubType().equals(included.getSubType()) || this.getSubType().equals("*"));
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
            for (Parameter param : this.getParameters()) {
                sb.append("; ").append(param.getName()).append('=').append(param.getValue());
            }
        }
        return sb.toString();
    }
}

