/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Response;
import org.restlet.engine.Engine;
import org.restlet.engine.util.ContextualRunnable;
import org.restlet.routing.VirtualHost;
import org.restlet.service.Service;

public class TaskService
extends Service
implements ScheduledExecutorService {
    private volatile boolean shutdownAllowed;
    private volatile ScheduledExecutorService wrapped;
    private volatile int corePoolSize;

    public static ScheduledExecutorService wrap(final ScheduledExecutorService executorService) {
        return new ScheduledExecutorService(){

            @Override
            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return executorService.awaitTermination(timeout, unit);
            }

            @Override
            public void execute(final Runnable runnable) {
                final Application currentApplication = Application.getCurrent();
                final Context currentContext = Context.getCurrent();
                final Integer currentVirtualHost = VirtualHost.getCurrent();
                final Response currentResponse = Response.getCurrent();
                executorService.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Response.setCurrent(currentResponse);
                        Context.setCurrent(currentContext);
                        VirtualHost.setCurrent(currentVirtualHost);
                        Application.setCurrent(currentApplication);
                        if (runnable instanceof ContextualRunnable) {
                            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(((ContextualRunnable)runnable).getContextClassLoader());
                                runnable.run();
                            }
                            finally {
                                Engine.clearThreadLocalVariables();
                                Thread.currentThread().setContextClassLoader(tccl);
                            }
                        }
                        try {
                            runnable.run();
                        }
                        finally {
                            Engine.clearThreadLocalVariables();
                        }
                    }
                });
            }

            public List invokeAll(Collection tasks) throws InterruptedException {
                return executorService.invokeAll(tasks);
            }

            public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
                return executorService.invokeAll(tasks, timeout, unit);
            }

            public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
                return executorService.invokeAny(tasks);
            }

            public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return executorService.invokeAny(tasks, timeout, unit);
            }

            @Override
            public boolean isShutdown() {
                return executorService.isShutdown();
            }

            @Override
            public boolean isTerminated() {
                return executorService.isTerminated();
            }

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
                return executorService.schedule(callable, delay, unit);
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                return executorService.schedule(command, delay, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
                return executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
                return executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
            }

            @Override
            public void shutdown() {
                executorService.shutdown();
            }

            @Override
            public List<Runnable> shutdownNow() {
                return executorService.shutdownNow();
            }

            @Override
            public <T> Future<T> submit(Callable<T> task) {
                return executorService.submit(task);
            }

            @Override
            public Future<?> submit(Runnable task) {
                return executorService.submit(task);
            }

            @Override
            public <T> Future<T> submit(Runnable task, T result) {
                return executorService.submit(task, result);
            }
        };
    }

    public TaskService() {
        this(true);
    }

    public TaskService(boolean enabled) {
        this(enabled, 4);
    }

    public TaskService(boolean enabled, int corePoolSize) {
        super(enabled);
        this.corePoolSize = corePoolSize;
        this.shutdownAllowed = false;
    }

    public TaskService(int corePoolSize) {
        this(true, corePoolSize);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.startIfNeeded();
        return this.getWrapped().awaitTermination(timeout, unit);
    }

    protected ScheduledExecutorService createExecutorService(int corePoolSize) {
        return Executors.newScheduledThreadPool(corePoolSize, this.createThreadFactory());
    }

    protected ThreadFactory createThreadFactory() {
        return new RestletThreadFactory();
    }

    @Override
    public void execute(Runnable command) {
        this.startIfNeeded();
        this.getWrapped().execute(command);
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    private ScheduledExecutorService getWrapped() {
        return this.wrapped;
    }

    public List invokeAll(Collection tasks) throws InterruptedException {
        this.startIfNeeded();
        return this.getWrapped().invokeAll(tasks);
    }

    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.startIfNeeded();
        return this.getWrapped().invokeAll(tasks, timeout, unit);
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        this.startIfNeeded();
        return this.getWrapped().invokeAny(tasks);
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.startIfNeeded();
        return this.getWrapped().invokeAny(tasks, timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.getWrapped() == null || this.getWrapped().isShutdown();
    }

    public boolean isShutdownAllowed() {
        return this.shutdownAllowed;
    }

    @Override
    public boolean isTerminated() {
        return this.getWrapped() == null || this.getWrapped().isTerminated();
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.startIfNeeded();
        return this.getWrapped().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.startIfNeeded();
        return this.getWrapped().schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.startIfNeeded();
        return this.getWrapped().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.startIfNeeded();
        return this.getWrapped().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setShutdownAllowed(boolean allowShutdown) {
        this.shutdownAllowed = allowShutdown;
    }

    private void setWrapped(ScheduledExecutorService wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void shutdown() {
        if (this.isShutdownAllowed() && this.getWrapped() != null) {
            this.getWrapped().shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.isShutdownAllowed() && this.getWrapped() != null ? this.getWrapped().shutdownNow() : Collections.emptyList();
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.getWrapped() == null || this.getWrapped().isShutdown()) {
            this.setWrapped(TaskService.wrap(this.createExecutorService(this.getCorePoolSize())));
        }
        super.start();
    }

    private void startIfNeeded() {
        if (!this.isStarted()) {
            try {
                this.start();
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to start the task service", e);
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        super.stop();
        if (this.getWrapped() != null && !this.getWrapped().isShutdown()) {
            this.getWrapped().shutdown();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.startIfNeeded();
        return this.getWrapped().submit(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.startIfNeeded();
        return this.getWrapped().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.startIfNeeded();
        return this.getWrapped().submit(task, result);
    }

    private static class RestletThreadFactory
    implements ThreadFactory {
        final ThreadFactory factory = Executors.defaultThreadFactory();

        private RestletThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = this.factory.newThread(runnable);
            t.setName(t.getName().replaceFirst("pool", "restlet"));
            return t;
        }
    }
}

