/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Form;
import org.restlet.engine.Method;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

public class AnnotationUtils {
    private final ConcurrentMap<Class<?>, List<AnnotationInfo>> cache = new ConcurrentHashMap();
    private static AnnotationUtils instance = new AnnotationUtils();

    public static AnnotationUtils getInstance() {
        return instance;
    }

    protected AnnotationUtils() {
    }

    private List<AnnotationInfo> addAnnotationDescriptors(List<AnnotationInfo> descriptors, Class<?> resourceClass, Class<?> initialResourceClass, java.lang.reflect.Method javaMethod) {
        List<AnnotationInfo> result = descriptors;
        if (result == null) {
            result = new CopyOnWriteArrayList<AnnotationInfo>();
        }
        for (Annotation annotation : javaMethod.getAnnotations()) {
            Method methodAnnotation = annotation.annotationType().getAnnotation(Method.class);
            org.restlet.data.Method restletMethod = this.getRestletMethod(annotation, methodAnnotation);
            if (restletMethod == null) continue;
            String toString = ((Object)annotation).toString();
            int startIndex = annotation.annotationType().getCanonicalName().length() + 8;
            int endIndex = toString.length() - 1;
            String value = null;
            if (endIndex > startIndex && "".equals(value = toString.substring(startIndex, endIndex))) {
                value = null;
            }
            result.add(new AnnotationInfo(initialResourceClass, restletMethod, javaMethod, value));
        }
        return result;
    }

    private List<AnnotationInfo> addAnnotations(List<AnnotationInfo> descriptors, Class<?> clazz, Class<?> initialClass) {
        List<AnnotationInfo> result = descriptors;
        if (clazz != null && !ServerResource.class.equals(clazz)) {
            Class<?>[] interfaces;
            if (result == null) {
                result = new CopyOnWriteArrayList<AnnotationInfo>();
            }
            if (clazz.isInterface()) {
                for (java.lang.reflect.Method javaMethod : clazz.getMethods()) {
                    this.addAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            } else {
                for (java.lang.reflect.Method javaMethod : clazz.getDeclaredMethods()) {
                    this.addAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            }
            if ((interfaces = clazz.getInterfaces()) != null) {
                for (Class<?> interfaceClass : interfaces) {
                    result = this.addAnnotations(result, interfaceClass, initialClass);
                }
            }
            this.addAnnotations(result, clazz.getSuperclass(), initialClass);
        }
        return result;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, java.lang.reflect.Method javaMethod) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.getJavaMethod().equals(javaMethod)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, org.restlet.data.Method restletMethod, Form query, Representation entity, MetadataService metadataService, ConverterService converterService) throws IOException {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.isCompatible(restletMethod, query, entity, metadataService, converterService)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public List<AnnotationInfo> getAnnotations(Class<?> clazz) {
        List<AnnotationInfo> prev;
        List<AnnotationInfo> result = (List<AnnotationInfo>)this.cache.get(clazz);
        if (result == null && (prev = this.cache.putIfAbsent(clazz, result = this.addAnnotations(result, clazz, clazz))) != null) {
            result = prev;
        }
        return result;
    }

    public List<AnnotationInfo> getAnnotations(Class<?> clazz, java.lang.reflect.Method javaMethod) {
        return this.addAnnotationDescriptors(null, clazz, clazz, javaMethod);
    }

    protected org.restlet.data.Method getRestletMethod(Annotation annotation, Annotation methodAnnotation) {
        return methodAnnotation == null ? null : org.restlet.data.Method.valueOf(((Method)methodAnnotation).value());
    }
}

