/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.engine.ClientHelper;
import org.restlet.engine.local.RiapServerHelper;

public class RiapClientHelper
extends ClientHelper {
    public RiapClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.RIAP);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.RIAP.getSchemeName().equalsIgnoreCase(scheme)) throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only RIAP is supported.");
        LocalReference ref = new LocalReference(request.getResourceRef());
        if (ref.getRiapAuthorityType() != 5) throw new IllegalArgumentException("Authority \"" + ref.getAuthority() + "\" not supported by the connector. Only \"component\" is supported.");
        if (RiapServerHelper.instance != null && RiapServerHelper.instance.getContext() != null && RiapServerHelper.instance.getContext().getClientDispatcher() != null) {
            RiapServerHelper.instance.getContext().getClientDispatcher().handle(request, response);
            return;
        } else {
            super.handle(request, response);
        }
    }
}

