/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import java.util.Collection;
import org.restlet.data.Status;
import org.restlet.data.Warning;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.util.DateUtils;

public class WarningReader
extends HeaderReader<Warning> {
    public static void addValues(Header header, Collection<Warning> collection) {
        new WarningReader(header.getValue()).addValues(collection);
    }

    public WarningReader(String header) {
        super(header);
    }

    @Override
    public Warning readValue() throws IOException {
        Warning result = new Warning();
        String code = this.readToken();
        this.skipSpaces();
        String agent = this.readRawText();
        this.skipSpaces();
        String text = this.readQuotedString();
        this.skipSpaces();
        String date = null;
        if (this.peek() != -1) {
            date = this.readQuotedString();
        }
        if (code == null || agent == null || text == null) {
            throw new IOException("Warning header malformed.");
        }
        result.setStatus(Status.valueOf(Integer.parseInt(code)));
        result.setAgent(agent);
        result.setText(text);
        if (date != null) {
            result.setDate(DateUtils.parse(date));
        }
        return result;
    }
}

