/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.representation.CharacterRepresentation;

public class StringRepresentation
extends CharacterRepresentation {
    private volatile CharSequence text;

    public StringRepresentation(char[] chars) {
        this((CharSequence)new String(chars), MediaType.TEXT_PLAIN);
    }

    public StringRepresentation(CharSequence text) {
        this(text, MediaType.TEXT_PLAIN);
    }

    public StringRepresentation(CharSequence text, Language language) {
        this(text, MediaType.TEXT_PLAIN, language);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType) {
        this(text, mediaType, null);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType, Language language) {
        this(text, mediaType, language, CharacterSet.UTF_8);
    }

    public StringRepresentation(CharSequence text, MediaType mediaType, Language language, CharacterSet characterSet) {
        super(mediaType);
        this.setMediaType(mediaType);
        if (language != null) {
            this.getLanguages().add(language);
        }
        this.setCharacterSet(characterSet);
        this.setText(text);
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getText() != null) {
            return new StringReader(this.getText());
        }
        return null;
    }

    @Override
    public InputStream getStream() throws IOException {
        CharacterSet charset = this.getCharacterSet() == null ? CharacterSet.ISO_8859_1 : this.getCharacterSet();
        ByteArrayInputStream result = new ByteArrayInputStream(this.getText().getBytes(charset.getName()));
        return result;
    }

    @Override
    public String getText() {
        return this.text == null ? null : ((Object)this.text).toString();
    }

    @Override
    public void release() {
        this.setText(null);
        super.release();
    }

    @Override
    public void setCharacterSet(CharacterSet characterSet) {
        super.setCharacterSet(characterSet);
        this.updateSize();
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.updateSize();
    }

    public void setText(String text) {
        this.setText((CharSequence)text);
    }

    @Override
    public String toString() {
        return this.getText();
    }

    protected void updateSize() {
        block5: {
            if (this.getText() != null) {
                try {
                    if (this.getCharacterSet() != null) {
                        this.setSize(this.getText().getBytes(this.getCharacterSet().getName()).length);
                        break block5;
                    }
                    this.setSize(this.getText().getBytes().length);
                }
                catch (UnsupportedEncodingException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to update size", e);
                    this.setSize(-1L);
                }
            } else {
                this.setSize(-1L);
            }
        }
    }

    @Override
    public void write(Writer writer) throws IOException {
        if (this.getText() != null) {
            writer.write(this.getText());
            writer.flush();
        }
    }
}

