/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.Digest;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class DigesterRepresentation
extends WrapperRepresentation {
    private final String algorithm;
    private volatile MessageDigest computedDigest;

    public DigesterRepresentation(Representation wrappedRepresentation) throws NoSuchAlgorithmException {
        this(wrappedRepresentation, "MD5");
    }

    public DigesterRepresentation(Representation wrappedRepresentation, String algorithm) throws NoSuchAlgorithmException {
        super(wrappedRepresentation);
        this.algorithm = algorithm;
        this.computedDigest = MessageDigest.getInstance(algorithm);
    }

    public boolean checkDigest() {
        Digest digest = this.getDigest();
        return digest != null && digest.equals(this.getComputedDigest());
    }

    public boolean checkDigest(String algorithm) {
        boolean result = false;
        if (this.algorithm != null && this.algorithm.equals(algorithm)) {
            result = this.checkDigest();
        } else {
            Digest digest = this.getDigest();
            if (digest != null && algorithm.equals(digest.getAlgorithm())) {
                result = digest.equals(this.computeDigest(algorithm));
            }
        }
        return result;
    }

    public Digest computeDigest() {
        return this.computeDigest("MD5");
    }

    public Digest computeDigest(String algorithm) {
        Digest result = null;
        if (this.algorithm != null && this.algorithm.equals(algorithm)) {
            result = this.getComputedDigest();
        } else if (this.isAvailable()) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                DigestInputStream dis = new DigestInputStream(this.getStream(), md);
                BioUtils.exhaust(dis);
                result = new Digest(algorithm, md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to check the digest of the representation.", e);
            }
        }
        return result;
    }

    @Override
    public long exhaust() throws IOException {
        long result = -1L;
        if (this.isAvailable()) {
            result = BioUtils.exhaust(this.getStream());
        }
        return result;
    }

    @Override
    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel(this.getStream());
    }

    public Digest getComputedDigest() {
        return new Digest(this.algorithm, this.computedDigest.digest());
    }

    @Override
    public Reader getReader() throws IOException {
        return BioUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    @Override
    public InputStream getStream() throws IOException {
        return new DigestInputStream(this.getWrappedRepresentation().getStream(), this.computedDigest);
    }

    @Override
    public String getText() throws IOException {
        String result = null;
        if (this.isAvailable()) {
            if (this.getSize() == 0L) {
                result = "";
            } else {
                StringWriter sw = new StringWriter();
                this.write(sw);
                result = sw.toString();
            }
        }
        return result;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        DigestOutputStream dos = new DigestOutputStream(outputStream, this.computedDigest);
        this.getWrappedRepresentation().write(dos);
        ((OutputStream)dos).flush();
    }

    @Override
    public void write(WritableByteChannel writableChannel) throws IOException {
        OutputStream os = NioUtils.getStream(writableChannel);
        this.write(os);
        os.flush();
    }

    @Override
    public void write(Writer writer) throws IOException {
        OutputStream os = BioUtils.getStream(writer, this.getCharacterSet());
        this.write(os);
        os.flush();
    }
}

