/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.LocalReference;
import org.restlet.data.Protocol;
import org.restlet.engine.TemplateDispatcher;
import org.restlet.engine.util.ChildContext;

public class ChildClientDispatcher
extends TemplateDispatcher {
    private ChildContext childContext;

    public ChildClientDispatcher(ChildContext childContext) {
        this.childContext = childContext;
    }

    @Override
    public int doHandle(Request request, Response response) {
        int result = 0;
        Protocol protocol = request.getProtocol();
        if (protocol.equals(Protocol.RIAP)) {
            LocalReference cr = new LocalReference(request.getResourceRef());
            if (cr.getRiapAuthorityType() == 4) {
                if (this.getChildContext() != null && this.getChildContext().getChild() instanceof Application) {
                    Application application = (Application)this.getChildContext().getChild();
                    request.getResourceRef().setBaseRef(request.getResourceRef().getHostIdentifier());
                    application.getInboundRoot().handle(request, response);
                }
            } else if (cr.getRiapAuthorityType() == 5) {
                this.parentHandle(request, response);
            } else if (cr.getRiapAuthorityType() == 6) {
                this.parentHandle(request, response);
            } else {
                this.getLogger().warning("Unknown RIAP authority. Only \"component\", \"host\" and \"application\" are supported.");
                result = 2;
            }
        } else {
            Application application;
            if (this.getChildContext() != null && this.getChildContext().getChild() instanceof Application && !(application = (Application)this.getChildContext().getChild()).getConnectorService().getClientProtocols().contains(protocol)) {
                this.getLogger().fine("The protocol used by this request is not declared in the application's connector service. Please update the list of client connectors used by your application and restart it.");
            }
            this.parentHandle(request, response);
        }
        return result;
    }

    private ChildContext getChildContext() {
        return this.childContext;
    }

    private void parentHandle(Request request, Response response) {
        if (this.getChildContext() != null) {
            if (this.getChildContext().getParentContext() != null) {
                if (this.getChildContext().getParentContext().getClientDispatcher() != null) {
                    this.getChildContext().getParentContext().getClientDispatcher().handle(request, response);
                } else {
                    this.getLogger().warning("The parent context doesn't have a client dispatcher available. Unable to handle call.");
                }
            } else {
                this.getLogger().warning("Your Restlet doesn't have a parent context available.");
            }
        } else {
            this.getLogger().warning("Your Restlet doesn't have a context available.");
        }
    }
}

