/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.engine.Edition;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.InputStreamChannel;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.io.NbChannelInputStream;
import org.restlet.engine.io.NbChannelOutputStream;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.representation.Representation;

public class NioUtils {
    public static int copy(ByteBuffer sourceBuffer, ByteBuffer targetBuffer, long maxCopied) {
        int maxBuffer = Math.min(sourceBuffer.remaining(), targetBuffer.remaining());
        int result = maxCopied == 0L ? maxBuffer : Math.min((int)maxCopied, maxBuffer);
        for (int i = 0; i < result; ++i) {
            targetBuffer.put(sourceBuffer.get());
        }
        return result;
    }

    public static void copy(FileChannel fileChannel, WritableByteChannel writableChannel) throws IOException {
        long position = 0L;
        long count = fileChannel.size();
        long written = 0L;
        SelectableChannel selectableChannel = null;
        if (writableChannel instanceof SelectableChannel) {
            selectableChannel = (SelectableChannel)((Object)writableChannel);
        }
        while (count > 0L) {
            NioUtils.waitForState(selectableChannel, 4);
            written = fileChannel.transferTo(position, count, writableChannel);
            position += written;
            count -= written;
        }
    }

    public static void copy(ReadableByteChannel readableChannel, OutputStream outputStream) throws IOException {
        if (readableChannel != null && outputStream != null) {
            BioUtils.copy((InputStream)new NbChannelInputStream(readableChannel), outputStream);
        }
    }

    public static void copy(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            BioUtils.copy((InputStream)new NbChannelInputStream(readableChannel), new NbChannelOutputStream(writableChannel));
        }
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) throws IOException {
        ReadableByteChannel result = null;
        if (inputStream instanceof FileInputStream) {
            result = ((FileInputStream)inputStream).getChannel();
        } else if (inputStream != null) {
            result = new InputStreamChannel(inputStream);
        }
        return result;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        Pipe.SourceChannel result = null;
        if (Edition.CURRENT != Edition.GAE) {
            final Pipe pipe = Pipe.open();
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Pipe.SinkChannel wbc = null;
                    try {
                        wbc = pipe.sink();
                        representation.write(wbc);
                    }
                    catch (IOException ioe) {
                        Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped channel.", ioe);
                    }
                    finally {
                        if (wbc != null) {
                            try {
                                wbc.close();
                            }
                            catch (IOException e) {
                                Context.getCurrentLogger().log(Level.FINE, "Error while closing to the piped channel.", e);
                            }
                        }
                    }
                }
            };
            Application application = Application.getCurrent();
            if (application != null && application.getTaskService() != null) {
                application.getTaskService().execute(task);
            } else {
                new Thread(task, "Restlet-PipedWritableChannel").start();
            }
            result = pipe.source();
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a channel for a representation given its write(WritableByteChannel) method.");
        }
        return result;
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        NbChannelInputStream result = null;
        if (readableChannel != null) {
            result = new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static OutputStream getStream(WritableByteChannel writableChannel) {
        return NioUtils.isBlocking(writableChannel) ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
    }

    public static boolean isBlocking(Channel channel) {
        boolean result = true;
        if (channel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)channel;
            result = selectableChannel.isBlocking();
        }
        return result;
    }

    public static void release(Selector selector, SelectionKey selectionKey) throws IOException {
        if (selectionKey != null) {
            selectionKey.cancel();
            if (selector != null) {
                selector.selectNow();
                SelectorFactory.returnSelector(selector);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForState(SelectableChannel selectableChannel, int operations) throws IOException {
        if (selectableChannel != null) {
            Selector selector = null;
            SelectionKey selectionKey = null;
            int selected = 0;
            try {
                selector = SelectorFactory.getSelector();
                while (selected == 0) {
                    selectionKey = selectableChannel.register(selector, operations);
                    selected = selector.select(IoUtils.TIMEOUT_MS);
                }
            }
            finally {
                NioUtils.release(selector, selectionKey);
            }
        }
    }

    private NioUtils() {
    }
}

