/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.Authorizer;
import org.restlet.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleAuthorizer
extends Authorizer {
    private List<Role> authorizedRoles = new CopyOnWriteArrayList<Role>();
    private List<Role> forbiddenRoles = new CopyOnWriteArrayList<Role>();

    public RoleAuthorizer() {
        this((String)null);
    }

    public RoleAuthorizer(String identifier) {
        super(identifier);
    }

    @Override
    public boolean authorize(Request request, Response response) {
        boolean authorized = false;
        boolean forbidden = false;
        if (this.getAuthorizedRoles().isEmpty()) {
            authorized = true;
        } else {
            for (Role authorizedRole : this.getAuthorizedRoles()) {
                authorized = authorized || request.getClientInfo().getRoles().contains(authorizedRole);
            }
        }
        for (Role forbiddenRole : this.getForbiddenRoles()) {
            forbidden = forbidden || request.getClientInfo().getRoles().contains(forbiddenRole);
        }
        return authorized && !forbidden;
    }

    public List<Role> getAuthorizedRoles() {
        return this.authorizedRoles;
    }

    public List<Role> getForbiddenRoles() {
        return this.forbiddenRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthorizedRoles(List<Role> authorizedRoles) {
        List<Role> list = this.getAuthorizedRoles();
        synchronized (list) {
            if (authorizedRoles != this.getAuthorizedRoles()) {
                this.getAuthorizedRoles().clear();
                if (authorizedRoles != null) {
                    this.getAuthorizedRoles().addAll(authorizedRoles);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForbiddenRoles(List<Role> forbiddenRoles) {
        List<Role> list = this.getForbiddenRoles();
        synchronized (list) {
            if (forbiddenRoles != this.getForbiddenRoles()) {
                this.getForbiddenRoles().clear();
                if (forbiddenRoles != null) {
                    this.getForbiddenRoles().addAll(forbiddenRoles);
                }
            }
        }
    }
}

