/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.IoUtils;
import org.restlet.util.SelectionListener;

public class SelectionRegistration {
    private final CyclicBarrier barrier;
    private volatile boolean canceling = false;
    private volatile int interestOperations;
    private volatile SelectionListener listener;
    private volatile int previousInterest;
    private volatile int readyOperations;
    private final SelectableChannel selectableChannel;
    private volatile SelectionKey selectionKey;

    public static String getName(int operation) {
        StringBuilder result = new StringBuilder();
        if ((operation & 0x10) != 0) {
            result.append("ACCEPT ");
        }
        if ((operation & 8) != 0) {
            result.append("CONNECT ");
        }
        if ((operation & 1) != 0) {
            result.append("READ ");
        }
        if ((operation & 4) != 0) {
            result.append("WRITE ");
        }
        if (operation == 0) {
            result.append("NONE ");
        }
        if (result.length() == 0) {
            result.append(operation);
        }
        return result.toString();
    }

    public SelectionRegistration(int interestOperations, SelectionListener listener) {
        this(null, interestOperations, listener);
    }

    public SelectionRegistration(SelectableChannel selectableChannel, int interestOperations, SelectionListener listener) {
        this.selectableChannel = selectableChannel;
        this.barrier = new CyclicBarrier(2);
        this.listener = listener;
        this.setInterestOperations(interestOperations);
    }

    public void addInterestOperations(int interest) {
        this.setInterestOperations(this.getInterestOperations() & interest);
    }

    public void block() throws IOException {
        try {
            if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                Context.getCurrentLogger().log(Level.FINEST, "Calling thread about to block on the NIO selection registration. Timeout: " + TimeUnit.MILLISECONDS.toMillis(IoUtils.TIMEOUT_MS) + " ms. Waiting: " + this.barrier.getNumberWaiting());
            }
            this.barrier.await(IoUtils.TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to block the thread at the cyclic barrier", e);
            IOException ioe = new IOException("Unable to block the thread at the cyclic barrier.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public void clear() {
        this.barrier.reset();
        this.canceling = false;
        this.interestOperations = 0;
        this.previousInterest = 0;
        this.readyOperations = 0;
        this.selectionKey = null;
    }

    public int getInterestOperations() {
        return this.interestOperations;
    }

    public SelectionListener getListener() {
        return this.listener;
    }

    public int getReadyOperations() {
        return this.readyOperations;
    }

    public SelectableChannel getSelectableChannel() {
        return this.selectableChannel;
    }

    public boolean isCanceling() {
        return this.canceling;
    }

    public boolean isConnectable() {
        return (this.getReadyOperations() & 8) != 0;
    }

    public boolean isInterestReady() {
        return (this.getReadyOperations() & this.getInterestOperations()) > 0;
    }

    public boolean isReadable() {
        return (this.getReadyOperations() & 1) != 0;
    }

    public boolean isWritable() {
        return (this.getReadyOperations() & 4) != 0;
    }

    public void onSelected(int readyOperations) throws IOException {
        this.readyOperations = readyOperations;
        if (this.getListener() != null && this.isInterestReady()) {
            this.getListener().onSelected();
        }
    }

    public SelectionKey register(Selector selector) {
        try {
            this.selectionKey = this.getSelectableChannel().register(selector, this.getInterestOperations(), this);
        }
        catch (ClosedChannelException cce) {
            Context.getCurrentLogger().log(Level.FINE, "Unable to register again", cce);
        }
        return this.selectionKey;
    }

    public void resume() {
        if (Context.getCurrentLogger().isLoggable(Level.FINER)) {
            Context.getCurrentLogger().log(Level.FINER, "Resuming previous NIO interest");
        }
        this.setInterestOperations(this.previousInterest);
    }

    public void setCanceling(boolean canceling) {
        this.canceling = canceling;
    }

    public boolean setInterestOperations(int interest) {
        boolean result = false;
        if (this.interestOperations != interest) {
            this.interestOperations = interest;
            result = true;
        }
        this.setReadyOperations(0);
        return result;
    }

    public void setListener(SelectionListener listener) {
        this.listener = listener;
    }

    public void setNoInterest() {
        this.setInterestOperations(0);
    }

    public void setReadInterest() {
        this.setInterestOperations(1);
    }

    public void setReadyOperations(int readyOperations) {
        this.readyOperations = readyOperations;
    }

    public void setWriteInterest() {
        this.setInterestOperations(4);
    }

    public void suspend() {
        this.previousInterest = this.getInterestOperations();
        this.setInterestOperations(0);
    }

    public String toString() {
        return "Interest= " + SelectionRegistration.getName(this.getInterestOperations()) + ", Ready=" + SelectionRegistration.getName(this.getReadyOperations()) + ", Canceling=" + Boolean.toString(this.isCanceling());
    }

    public void unblock() throws IOException {
        if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
            Context.getCurrentLogger().log(Level.FINEST, "Calling thread about to unblock the NIO selection registration. Timeout: " + TimeUnit.MILLISECONDS.toMillis(IoUtils.TIMEOUT_MS) + " ms. Waiting: " + this.barrier.getNumberWaiting());
        }
        try {
            this.barrier.await(IoUtils.TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to unblock the waiting thread at the cyclic barrier", e);
            IOException ioe = new IOException("Unable to unblock the waiting thread at the cyclic barrier.");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public SelectionKey update() {
        if (this.selectionKey.isValid()) {
            if (this.isCanceling()) {
                Context.getCurrentLogger().log(Level.FINER, "Cancelling of the selection key requested");
                this.selectionKey.cancel();
            } else {
                try {
                    if (Context.getCurrentLogger().isLoggable(Level.FINEST)) {
                        Context.getCurrentLogger().log(Level.FINEST, "Update key (old | new) : " + SelectionRegistration.getName(this.selectionKey.interestOps()) + " | " + SelectionRegistration.getName(this.getInterestOperations()));
                    }
                    this.selectionKey.interestOps(this.getInterestOperations());
                }
                catch (CancelledKeyException cke) {
                    Context.getCurrentLogger().log(Level.FINE, "Unable to update a cancelled key, registering again", cke);
                    this.selectionKey = this.register(this.selectionKey.selector());
                }
            }
        } else {
            Context.getCurrentLogger().log(Level.FINE, "Invalid key detected, registering again");
            this.selectionKey = this.register(this.selectionKey.selector());
        }
        return this.selectionKey;
    }
}

