/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;

public abstract class CharacterRepresentation
extends Representation {
    public CharacterRepresentation(MediaType mediaType) {
        super(mediaType);
        this.setCharacterSet(CharacterSet.UTF_8);
    }

    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel(this.getStream());
    }

    public InputStream getStream() throws IOException {
        return BioUtils.getInputStream(this.getReader(), this.getCharacterSet());
    }

    public void write(OutputStream outputStream) throws IOException {
        Writer writer = BioUtils.getWriter(outputStream, this.getCharacterSet());
        this.write(writer);
        writer.flush();
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        OutputStream os = NioUtils.getOutputStream(writableChannel);
        this.write(os);
        os.flush();
    }
}

