/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import java.util.Iterator;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.header.PreferenceWriter;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceReader<T extends Metadata>
extends HeaderReader<Preference<T>> {
    public static final int TYPE_CHARACTER_SET = 1;
    public static final int TYPE_ENCODING = 2;
    public static final int TYPE_LANGUAGE = 3;
    public static final int TYPE_MEDIA_TYPE = 4;
    private volatile int type;

    public static void addCharacterSets(String acceptCharsetHeader, ClientInfo clientInfo) {
        if (acceptCharsetHeader != null) {
            if (acceptCharsetHeader.length() == 0) {
                clientInfo.getAcceptedCharacterSets().add(new Preference<CharacterSet>(CharacterSet.ISO_8859_1));
            } else {
                PreferenceReader pr = new PreferenceReader(1, acceptCharsetHeader);
                pr.addValues(clientInfo.getAcceptedCharacterSets());
            }
        } else {
            clientInfo.getAcceptedCharacterSets().add(new Preference<CharacterSet>(CharacterSet.ALL));
        }
    }

    public static void addEncodings(String acceptEncodingHeader, ClientInfo clientInfo) {
        if (acceptEncodingHeader != null) {
            PreferenceReader pr = new PreferenceReader(2, acceptEncodingHeader);
            pr.addValues(clientInfo.getAcceptedEncodings());
        } else {
            clientInfo.getAcceptedEncodings().add(new Preference<Encoding>(Encoding.IDENTITY));
        }
    }

    public static void addLanguages(String acceptLanguageHeader, ClientInfo clientInfo) {
        if (acceptLanguageHeader != null) {
            PreferenceReader pr = new PreferenceReader(3, acceptLanguageHeader);
            pr.addValues(clientInfo.getAcceptedLanguages());
        } else {
            clientInfo.getAcceptedLanguages().add(new Preference<Language>(Language.ALL));
        }
    }

    public static void addMediaTypes(String acceptMediaTypeHeader, ClientInfo clientInfo) {
        if (acceptMediaTypeHeader != null) {
            PreferenceReader pr = new PreferenceReader(4, acceptMediaTypeHeader);
            pr.addValues(clientInfo.getAcceptedMediaTypes());
        } else {
            clientInfo.getAcceptedMediaTypes().add(new Preference<MediaType>(MediaType.ALL));
        }
    }

    public static float readQuality(String quality) {
        try {
            float result = Float.valueOf(quality).floatValue();
            if (PreferenceWriter.isValidQuality(result)) {
                return result;
            }
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid quality value detected. Value must be between 0 and 1.");
        }
    }

    public PreferenceReader(int type, String header) {
        super(header);
        this.type = type;
    }

    protected Preference<T> createPreference(CharSequence metadata, Series<Parameter> parameters) {
        Preference<Object> result;
        if (parameters == null) {
            result = new Preference<Metadata>();
            switch (this.type) {
                case 1: {
                    result.setMetadata(CharacterSet.valueOf(((Object)metadata).toString()));
                    break;
                }
                case 2: {
                    result.setMetadata(Encoding.valueOf(((Object)metadata).toString()));
                    break;
                }
                case 3: {
                    result.setMetadata(Language.valueOf(((Object)metadata).toString()));
                    break;
                }
                case 4: {
                    result.setMetadata(MediaType.valueOf(((Object)metadata).toString()));
                }
            }
        } else {
            Series<Parameter> mediaParams = this.extractMediaParams(parameters);
            float quality = this.extractQuality(parameters);
            result = new Preference<Object>(null, quality, parameters);
            switch (this.type) {
                case 1: {
                    result.setMetadata(new CharacterSet(((Object)metadata).toString()));
                    break;
                }
                case 2: {
                    result.setMetadata(new Encoding(((Object)metadata).toString()));
                    break;
                }
                case 3: {
                    result.setMetadata(new Language(((Object)metadata).toString()));
                    break;
                }
                case 4: {
                    result.setMetadata(new MediaType(((Object)metadata).toString(), mediaParams));
                }
            }
        }
        return result;
    }

    protected Series<Parameter> extractMediaParams(Series<Parameter> parameters) {
        Series<Parameter> result = null;
        boolean qualityFound = false;
        Parameter param = null;
        if (parameters != null) {
            result = new Series<Parameter>(Parameter.class);
            Iterator iter = parameters.iterator();
            while (!qualityFound && iter.hasNext()) {
                param = (Parameter)iter.next();
                if (param.getName().equals("q")) {
                    qualityFound = true;
                    continue;
                }
                iter.remove();
                result.add(param);
            }
        }
        return result;
    }

    protected float extractQuality(Series<Parameter> parameters) {
        float result = 1.0f;
        boolean found = false;
        if (parameters != null) {
            Parameter param = null;
            Iterator iter = parameters.iterator();
            while (!found && iter.hasNext()) {
                param = (Parameter)iter.next();
                if (!param.getName().equals("q")) continue;
                result = PreferenceReader.readQuality(param.getValue());
                found = true;
                iter.remove();
            }
        }
        return result;
    }

    @Override
    public Preference<T> readValue() throws IOException {
        Preference<T> result = null;
        boolean readingMetadata = true;
        boolean readingParamName = false;
        boolean readingParamValue = false;
        StringBuilder metadataBuffer = new StringBuilder();
        StringBuilder paramNameBuffer = null;
        StringBuilder paramValueBuffer = null;
        Series<Parameter> parameters = null;
        int next = 0;
        while (result == null) {
            next = this.read();
            if (readingMetadata) {
                if (next == -1 || HeaderUtils.isComma(next)) {
                    if (metadataBuffer.length() <= 0) break;
                    result = this.createPreference(metadataBuffer, null);
                    continue;
                }
                if (next == 59) {
                    if (metadataBuffer.length() > 0) {
                        readingMetadata = false;
                        readingParamName = true;
                        paramNameBuffer = new StringBuilder();
                        parameters = new Series<Parameter>(Parameter.class);
                        continue;
                    }
                    throw new IOException("Empty metadata name detected.");
                }
                if (HeaderUtils.isSpace(next)) continue;
                if (HeaderUtils.isText(next)) {
                    metadataBuffer.append((char)next);
                    continue;
                }
                throw new IOException("Unexpected character \"" + (char)next + "\" detected.");
            }
            if (readingParamName) {
                if (next == 61) {
                    if (paramNameBuffer.length() > 0) {
                        readingParamName = false;
                        readingParamValue = true;
                        paramValueBuffer = new StringBuilder();
                        continue;
                    }
                    throw new IOException("Empty parameter name detected.");
                }
                if (next == -1 || HeaderUtils.isComma(next)) {
                    if (paramNameBuffer.length() > 0) {
                        parameters.add(Parameter.create(paramNameBuffer, null));
                        result = this.createPreference(metadataBuffer, parameters);
                        continue;
                    }
                    throw new IOException("Empty parameter name detected.");
                }
                if (next == 59) {
                    parameters.add(Parameter.create(paramNameBuffer, null));
                    paramNameBuffer = new StringBuilder();
                    readingParamName = true;
                    readingParamValue = false;
                    continue;
                }
                if (HeaderUtils.isSpace(next) && paramNameBuffer.length() == 0) continue;
                if (HeaderUtils.isTokenChar(next)) {
                    paramNameBuffer.append((char)next);
                    continue;
                }
                throw new IOException("Unexpected character \"" + (char)next + "\" detected.");
            }
            if (!readingParamValue) continue;
            if (next == -1 || HeaderUtils.isComma(next) || HeaderUtils.isSpace(next)) {
                if (paramValueBuffer.length() > 0) {
                    parameters.add(Parameter.create(paramNameBuffer, paramValueBuffer));
                    result = this.createPreference(metadataBuffer, parameters);
                    continue;
                }
                throw new IOException("Empty parameter value detected");
            }
            if (next == 59) {
                parameters.add(Parameter.create(paramNameBuffer, paramValueBuffer));
                paramNameBuffer = new StringBuilder();
                readingParamName = true;
                readingParamValue = false;
                continue;
            }
            if (next == 34 && paramValueBuffer.length() == 0) {
                boolean done = false;
                boolean quotedPair = false;
                while (!done && next != -1) {
                    next = this.read();
                    if (quotedPair) {
                        if (HeaderUtils.isText(next)) {
                            paramValueBuffer.append((char)next);
                            quotedPair = false;
                            continue;
                        }
                        throw new IOException("Invalid character detected in quoted string. Please check your value");
                    }
                    if (HeaderUtils.isDoubleQuote(next)) {
                        done = true;
                        continue;
                    }
                    if (next == 92) {
                        quotedPair = true;
                        continue;
                    }
                    if (HeaderUtils.isText(next)) {
                        paramValueBuffer.append((char)next);
                        continue;
                    }
                    throw new IOException("Invalid character detected in quoted string. Please check your value");
                }
                continue;
            }
            if (HeaderUtils.isTokenChar(next)) {
                paramValueBuffer.append((char)next);
                continue;
            }
            throw new IOException("Unexpected character \"" + (char)next + "\" detected.");
        }
        if (HeaderUtils.isComma(next)) {
            this.unread();
        }
        return result;
    }
}

