/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.restlet.Client;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientInboundWay;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.io.IoState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientInboundWay
extends ClientInboundWay {
    private final Queue<Response> messages = new ConcurrentLinkedQueue<Response>();

    public HttpClientInboundWay(Connection<Client> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.messages.clear();
    }

    @Override
    protected Response createResponse(Status status) {
        Response result = null;
        Response finalResponse = this.getMessages().peek();
        result = status.isInformational() ? new Response(finalResponse.getRequest()) : finalResponse;
        return result;
    }

    @Override
    public int getLoadScore() {
        return this.getMessages().size();
    }

    public Queue<Response> getMessages() {
        return this.messages;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.getMessages().isEmpty();
    }

    protected boolean isReady() {
        return this.getBuffer().canDrain() && this.getMessageState() == MessageState.BODY && this.getEntityRegistration().getListener() != null;
    }

    @Override
    public void onCompleted(boolean endDetected) {
        if (this.getMessage() != null) {
            this.getMessages().remove(this.getMessage());
        }
        super.onCompleted(endDetected);
    }

    @Override
    public void onError(Status status) {
        for (Response rsp : this.getMessages()) {
            if (rsp == this.getMessage()) continue;
            this.getMessages().remove(rsp);
            this.getHelper().onInboundError(status, rsp);
        }
        super.onError(status);
    }

    @Override
    public void updateState() {
        if (this.getIoState() == IoState.IDLE && !this.isEmpty()) {
            this.setIoState(IoState.INTEREST);
        }
        super.updateState();
    }
}

