/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.WrapperChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableSizedChannel
extends WrapperChannel<ReadableByteChannel>
implements ReadableByteChannel {
    private volatile long availableSize;

    public ReadableSizedChannel(ReadableByteChannel source, long availableSize) {
        super(source);
        this.availableSize = availableSize;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            if (this.availableSize < (long)dst.remaining()) {
                dst.limit((int)(this.availableSize + (long)dst.position()));
            }
            result = ((ReadableByteChannel)this.getWrappedChannel()).read(dst);
        }
        if (result > 0) {
            this.availableSize -= (long)result;
            if (Context.getCurrentLogger().isLoggable(Level.FINE)) {
                Context.getCurrentLogger().fine("Bytes read / available : " + result + " / " + this.availableSize);
            }
            if (this.availableSize == 0L && Context.getCurrentLogger().isLoggable(Level.FINE)) {
                Context.getCurrentLogger().fine("Channel fully read.");
            }
        }
        if (this.getWrappedChannel() instanceof ReadableBufferedChannel) {
            ((ReadableBufferedChannel)this.getWrappedChannel()).postRead(result);
        }
        return result;
    }
}

