/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InternetDateFormat
extends DateFormat {
    private static volatile DecimalFormat df2 = new DecimalFormat("00");
    private static volatile DecimalFormat df4 = new DecimalFormat("0000");
    private static volatile Pattern pattern;
    private static final long serialVersionUID = 1L;
    public static final TimeZone UTC;
    private Calendar cal;

    public static String now() {
        return InternetDateFormat.now(UTC);
    }

    public static String now(TimeZone zone) {
        return InternetDateFormat.toString(System.currentTimeMillis(), zone);
    }

    private static void parse(String s, Calendar cal) {
        Matcher m = pattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid date/time: " + s);
        }
        cal.clear();
        cal.set(1, Integer.parseInt(m.group(1)));
        cal.set(2, Integer.parseInt(m.group(2)) - 1);
        cal.set(5, Integer.parseInt(m.group(3)));
        cal.set(11, Integer.parseInt(m.group(4)));
        cal.set(12, Integer.parseInt(m.group(5)));
        cal.set(13, Integer.parseInt(m.group(6)));
        if (m.group(7) != null) {
            float fraction = Float.parseFloat(m.group(7));
            cal.set(14, (int)(fraction * 1000.0f));
        }
        if (m.group(8) != null) {
            cal.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else {
            int sign = m.group(9).equals("-") ? -1 : 1;
            int tzhour = Integer.parseInt(m.group(10));
            int tzminute = Integer.parseInt(m.group(11));
            int offset = sign * (tzhour * 60 + tzminute);
            String id = Integer.toString(offset);
            cal.setTimeZone(new SimpleTimeZone(offset * 60000, id));
        }
    }

    public static Calendar parseCalendar(String s) {
        GregorianCalendar cal = new GregorianCalendar();
        InternetDateFormat.parse(s, cal);
        return cal;
    }

    public static Date parseDate(String s) {
        GregorianCalendar cal = new GregorianCalendar();
        InternetDateFormat.parse(s, cal);
        return cal.getTime();
    }

    public static long parseTime(String s) {
        GregorianCalendar cal = new GregorianCalendar();
        InternetDateFormat.parse(s, cal);
        return cal.getTimeInMillis();
    }

    public static String toString(Calendar cal) {
        int tzminute;
        StringBuilder buf = new StringBuilder();
        buf.append(df4.format(cal.get(1)));
        buf.append("-");
        buf.append(df2.format(cal.get(2) + 1));
        buf.append("-");
        buf.append(df2.format(cal.get(5)));
        buf.append("T");
        buf.append(df2.format(cal.get(11)));
        buf.append(":");
        buf.append(df2.format(cal.get(12)));
        buf.append(":");
        buf.append(df2.format(cal.get(13)));
        int ms = cal.get(14);
        if (ms != 0) {
            buf.append(".").append((int)((float)ms / 10.0f));
        }
        if ((tzminute = (cal.get(15) + cal.get(16)) / 60000) == 0) {
            buf.append("Z");
        } else {
            if (tzminute < 0) {
                tzminute = -tzminute;
                buf.append("-");
            } else {
                buf.append("+");
            }
            int tzhour = tzminute / 60;
            buf.append(df2.format(tzhour));
            buf.append(":");
            buf.append(df2.format(tzminute -= tzhour * 60));
        }
        return buf.toString();
    }

    public static String toString(Date date) {
        return InternetDateFormat.toString(date, UTC);
    }

    public static String toString(Date date, TimeZone zone) {
        InternetDateFormat dt = new InternetDateFormat(date, zone);
        return dt.toString();
    }

    public static String toString(long time) {
        return InternetDateFormat.toString(time, UTC);
    }

    public static String toString(long time, TimeZone zone) {
        InternetDateFormat dt = new InternetDateFormat(time, zone);
        return dt.toString();
    }

    public static InternetDateFormat valueOf(Date date) {
        return new InternetDateFormat(date);
    }

    public static InternetDateFormat valueOf(Date date, TimeZone zone) {
        return new InternetDateFormat(date, zone);
    }

    public static InternetDateFormat valueOf(long time) {
        return new InternetDateFormat(time);
    }

    public static InternetDateFormat valueOf(long time, TimeZone zone) {
        return new InternetDateFormat(time, zone);
    }

    public static InternetDateFormat valueOf(String s) {
        return new InternetDateFormat(s);
    }

    public InternetDateFormat() {
        this(UTC);
    }

    public InternetDateFormat(Calendar cal) {
        this.cal = (Calendar)cal.clone();
    }

    public InternetDateFormat(Date date) {
        this(date, UTC);
    }

    public InternetDateFormat(Date date, TimeZone zone) {
        this.cal = new GregorianCalendar(zone);
        this.cal.setTime(date);
    }

    public InternetDateFormat(long time) {
        this(time, UTC);
    }

    public InternetDateFormat(long time, TimeZone zone) {
        this.cal = new GregorianCalendar(zone);
        this.cal.setTimeInMillis(time);
    }

    public InternetDateFormat(String s) {
        this.cal = InternetDateFormat.parseCalendar(s);
    }

    public InternetDateFormat(TimeZone zone) {
        this.cal = new GregorianCalendar(zone);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return toAppendTo.append(InternetDateFormat.valueOf(date));
    }

    public Calendar getCalendar() {
        return (Calendar)this.cal.clone();
    }

    public Date getDate() {
        return this.cal.getTime();
    }

    public long getTime() {
        return this.cal.getTimeInMillis();
    }

    public Date parse(String source) throws ParseException {
        return this.parse(source, null);
    }

    public Date parse(String source, ParsePosition pos) {
        return InternetDateFormat.parseDate(source);
    }

    public String toString() {
        return InternetDateFormat.toString(this.cal);
    }

    static {
        UTC = new SimpleTimeZone(0, "Z");
        String reDate = "(\\d{4})-(\\d{2})-(\\d{2})";
        String reTime = "(\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?";
        String reZone = "(?:([zZ])|(?:(\\+|\\-)(\\d{2}):(\\d{2})))";
        String re = reDate + "[tT\\s]" + reTime + reZone;
        pattern = Pattern.compile(re);
    }
}

