/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Range;
import org.restlet.data.Status;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.local.Entity;
import org.restlet.engine.local.EntityClientHelper;
import org.restlet.engine.local.FileEntity;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

public class FileClientHelper
extends EntityClientHelper {
    public FileClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.FILE);
    }

    protected boolean checkExtensionsConsistency(File file) {
        boolean knownExtension = true;
        Collection<String> set = Entity.getExtensions(file.getName(), this.getMetadataService());
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext() && knownExtension) {
            knownExtension = this.getMetadataService().getMetadata(iterator.next()) != null;
        }
        return knownExtension;
    }

    private boolean checkMetadataConsistency(String fileName, Representation representation) {
        boolean result = true;
        if (representation != null) {
            Variant var = new Variant();
            Entity.updateMetadata(fileName, var, true, this.getMetadataService());
            if (!(var.getLanguages().isEmpty() || representation.getLanguages().isEmpty() || var.getLanguages().containsAll(representation.getLanguages()))) {
                result = false;
            }
            if (var.getMediaType() != null && representation.getMediaType() != null && !var.getMediaType().includes(representation.getMediaType())) {
                result = false;
            }
            if (!(var.getEncodings().isEmpty() || representation.getEncodings().isEmpty() || var.getEncodings().containsAll(representation.getEncodings()))) {
                result = false;
            }
        }
        return result;
    }

    public Entity getEntity(String decodedPath) {
        return new FileEntity(new File(LocalReference.localizePath(decodedPath)), this.getMetadataService());
    }

    public String getTemporaryExtension() {
        return this.getHelpedParameters().getFirstValue("temporaryExtension", "tmp");
    }

    protected void handleLocal(Request request, Response response, String decodedPath) {
        String scheme = request.getResourceRef().getScheme();
        if (!Protocol.FILE.getSchemeName().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only FILE is supported.");
        }
        this.handleFile(request, response, decodedPath);
    }

    protected void handleFile(Request request, Response response, String decodedPath) {
        if (Method.GET.equals(request.getMethod()) || Method.HEAD.equals(request.getMethod())) {
            this.handleEntityGet(request, response, this.getEntity(decodedPath));
        } else if (Method.PUT.equals(request.getMethod())) {
            this.handleFilePut(request, response, decodedPath, new File(decodedPath));
        } else if (Method.DELETE.equals(request.getMethod())) {
            this.handleFileDelete(response, new File(decodedPath));
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
            response.getAllowedMethods().add(Method.PUT);
            response.getAllowedMethods().add(Method.DELETE);
        }
    }

    protected void handleFileDelete(Response response, File file) {
        if (file.isDirectory()) {
            if (file.listFiles().length == 0) {
                if (BioUtils.delete(file)) {
                    response.setStatus(Status.SUCCESS_NO_CONTENT);
                } else {
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the directory");
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, "Couldn't delete the non-empty directory");
            }
        } else if (BioUtils.delete(file)) {
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        } else {
            response.setStatus(Status.SERVER_ERROR_INTERNAL, "Couldn't delete the file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handleFilePut(Request request, Response response, String path, File file) {
        block96: {
            FileOutputStream fos;
            block97: {
                block100: {
                    RandomAccessFile raf;
                    block95: {
                        boolean partialPut;
                        block98: {
                            boolean error;
                            File tmp;
                            block93: {
                                FileOutputStream fos2;
                                block94: {
                                    block99: {
                                        RandomAccessFile raf2;
                                        block92: {
                                            boolean isDirectory = false;
                                            if (file.exists()) {
                                                if (file.isDirectory()) {
                                                    isDirectory = true;
                                                    response.setStatus(new Status(Status.CLIENT_ERROR_FORBIDDEN, "Can't put a new representation of a directory"));
                                                    return;
                                                }
                                            } else if (path.endsWith("/")) {
                                                isDirectory = true;
                                                if (file.mkdirs()) {
                                                    response.setStatus(Status.SUCCESS_NO_CONTENT);
                                                } else {
                                                    this.getLogger().log(Level.WARNING, "Unable to create the new directory");
                                                    response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new directory"));
                                                }
                                                return;
                                            }
                                            if (isDirectory) break block96;
                                            boolean bl = partialPut = !request.getRanges().isEmpty();
                                            if (!this.checkMetadataConsistency(file.getName(), request.getEntity())) {
                                                response.setStatus(new Status(Status.REDIRECTION_SEE_OTHER, "The metadata are not consistent with the URI"));
                                                return;
                                            }
                                            final String baseName = Entity.getBaseName(file.getName(), this.getMetadataService());
                                            FileFilter filter = new FileFilter(){

                                                public boolean accept(File file) {
                                                    return file.isFile() && baseName.equals(Entity.getBaseName(file.getName(), FileClientHelper.this.getMetadataService()));
                                                }
                                            };
                                            File[] files = file.getParentFile().listFiles(filter);
                                            File uniqueVariant = null;
                                            ArrayList<File> variantsList = new ArrayList<File>();
                                            if (files != null && files.length > 0) {
                                                Variant variant = new Variant();
                                                Entity.updateMetadata(file.getName(), variant, true, this.getMetadataService());
                                                Collection<String> extensions = Entity.getExtensions(variant, this.getMetadataService());
                                                for (File entry : files) {
                                                    Collection<String> entryExtensions = Entity.getExtensions(entry.getName(), this.getMetadataService());
                                                    if (!entryExtensions.containsAll(extensions)) continue;
                                                    variantsList.add(entry);
                                                    if (!extensions.containsAll(entryExtensions)) continue;
                                                    uniqueVariant = entry;
                                                }
                                            }
                                            if (uniqueVariant != null) {
                                                file = uniqueVariant;
                                            } else {
                                                if (!variantsList.isEmpty()) {
                                                    response.setStatus(new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely."));
                                                    return;
                                                }
                                                Entity.updateMetadata(file.getName(), request.getEntity(), true, this.getMetadataService());
                                                StringBuilder fileName = new StringBuilder(baseName);
                                                this.updateFileExtension(fileName, request.getEntity().getMediaType());
                                                for (Language language : request.getEntity().getLanguages()) {
                                                    this.updateFileExtension(fileName, language);
                                                }
                                                for (Encoding encoding : request.getEntity().getEncodings()) {
                                                    this.updateFileExtension(fileName, encoding);
                                                }
                                                file = new File(file.getParentFile(), fileName.toString());
                                            }
                                            if (!this.checkExtensionsConsistency(file)) {
                                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to process properly the URI. At least one extension is not known by the server."));
                                                return;
                                            }
                                            tmp = null;
                                            error = false;
                                            if (!file.exists()) break block98;
                                            if (!partialPut) break block99;
                                            raf2 = null;
                                            tmp = new File(file.getCanonicalPath() + "." + this.getTemporaryExtension());
                                            Range range = request.getRanges().get(0);
                                            if (tmp.exists() && !this.isResumeUpload()) {
                                                BioUtils.delete(tmp);
                                            }
                                            if (!tmp.exists()) {
                                                FileInputStream in = new FileInputStream(file);
                                                FileOutputStream out = new FileOutputStream(tmp);
                                                BioUtils.copy((InputStream)in, out);
                                                out.flush();
                                                ((OutputStream)out).close();
                                            }
                                            raf2 = new RandomAccessFile(tmp, "rwd");
                                            if (range.getIndex() == -1L) {
                                                if (raf2.length() <= range.getSize()) {
                                                    raf2.seek(range.getSize());
                                                } else {
                                                    raf2.seek(raf2.length() - range.getSize());
                                                }
                                            } else {
                                                raf2.seek(range.getIndex());
                                            }
                                            if (!request.isEntityAvailable()) break block92;
                                            BioUtils.copy(request.getEntity().getStream(), raf2);
                                        }
                                        Object var20_35 = null;
                                        try {
                                            if (raf2 != null) {
                                                raf2.close();
                                            }
                                            break block93;
                                        }
                                        catch (IOException ioe2) {
                                            this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe2);
                                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe2);
                                            error = true;
                                        }
                                        break block93;
                                        {
                                            catch (IOException ioe) {
                                                this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
                                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file"));
                                                error = true;
                                                Object var20_36 = null;
                                                try {
                                                    if (raf2 != null) {
                                                        raf2.close();
                                                    }
                                                    break block93;
                                                }
                                                catch (IOException ioe2) {
                                                    this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe2);
                                                    response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe2);
                                                    error = true;
                                                }
                                                break block93;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var20_37 = null;
                                            try {
                                                if (raf2 != null) {
                                                    raf2.close();
                                                }
                                            }
                                            catch (IOException ioe2) {
                                                this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe2);
                                                response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe2);
                                                error = true;
                                            }
                                            throw throwable;
                                        }
                                    }
                                    fos2 = null;
                                    tmp = File.createTempFile("restlet-upload", "bin");
                                    if (!request.isEntityAvailable()) break block94;
                                    fos2 = new FileOutputStream(tmp);
                                    BioUtils.copy(request.getEntity().getStream(), fos2);
                                }
                                Object var23_42 = null;
                                try {
                                    if (fos2 != null) {
                                        fos2.close();
                                    }
                                    break block93;
                                }
                                catch (IOException ioe3) {
                                    this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe3);
                                    response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe3);
                                    error = true;
                                }
                                break block93;
                                {
                                    catch (IOException ioe) {
                                        this.getLogger().log(Level.WARNING, "Unable to create the temporary file", ioe);
                                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create a temporary file"));
                                        error = true;
                                        Object var23_43 = null;
                                        try {
                                            if (fos2 != null) {
                                                fos2.close();
                                            }
                                            break block93;
                                        }
                                        catch (IOException ioe3) {
                                            this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe3);
                                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe3);
                                            error = true;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var23_44 = null;
                                    try {
                                        if (fos2 != null) {
                                            fos2.close();
                                        }
                                    }
                                    catch (IOException ioe3) {
                                        this.getLogger().log(Level.WARNING, "Unable to close the temporary file", ioe3);
                                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe3);
                                        error = true;
                                    }
                                    throw throwable;
                                }
                            }
                            if (error) {
                                if (tmp.exists() && !this.isResumeUpload()) {
                                    BioUtils.delete(tmp);
                                }
                                return;
                            }
                            if (tmp.exists() && BioUtils.delete(file)) {
                                boolean renameSuccessful = false;
                                if (tmp.renameTo(file)) {
                                    if (request.getEntity() == null) {
                                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                                    } else {
                                        response.setStatus(Status.SUCCESS_OK);
                                    }
                                    renameSuccessful = true;
                                } else {
                                    if (tmp.exists()) {
                                        try {
                                            FileInputStream in = new FileInputStream(tmp);
                                            FileOutputStream out = new FileOutputStream(file);
                                            BioUtils.copy((InputStream)in, out);
                                            ((OutputStream)out).close();
                                            renameSuccessful = true;
                                            BioUtils.delete(tmp);
                                        }
                                        catch (Exception e) {
                                            renameSuccessful = false;
                                        }
                                    }
                                    if (!renameSuccessful) {
                                        this.getLogger().log(Level.WARNING, "Unable to move the temporary file to replace the existing file");
                                        response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to move the temporary file to replace the existing file"));
                                    }
                                }
                            } else {
                                this.getLogger().log(Level.WARNING, "Unable to delete the existing file");
                                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to delete the existing file"));
                                if (tmp.exists() && !this.isResumeUpload()) {
                                    BioUtils.delete(tmp);
                                }
                            }
                            break block96;
                        }
                        File parent = file.getParentFile();
                        if (parent != null && !parent.exists() && !parent.mkdirs()) {
                            this.getLogger().log(Level.WARNING, "Unable to create the parent directory");
                            response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the parent directory"));
                        }
                        if (!partialPut) break block100;
                        raf = null;
                        raf = new RandomAccessFile(file, "rwd");
                        Range range = request.getRanges().get(0);
                        if (range.getIndex() == -1L) {
                            if (raf.length() <= range.getSize()) {
                                raf.seek(range.getSize());
                            } else {
                                raf.seek(raf.length() - range.getSize());
                            }
                        } else {
                            raf.seek(range.getIndex());
                        }
                        if (!request.isEntityAvailable()) break block95;
                        BioUtils.copy(request.getEntity().getStream(), raf);
                    }
                    Object var26_49 = null;
                    try {
                        if (raf != null) {
                            raf.close();
                        }
                        break block96;
                    }
                    catch (IOException ioe4) {
                        this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe4);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe4);
                    }
                    break block96;
                    {
                        catch (FileNotFoundException fnfe) {
                            this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, fnfe);
                            Object var26_50 = null;
                            try {
                                if (raf != null) {
                                    raf.close();
                                }
                                break block96;
                            }
                            catch (IOException ioe4) {
                                this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe4);
                                response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe4);
                            }
                            break block96;
                        }
                        catch (IOException ioe) {
                            this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                            Object var26_51 = null;
                            try {
                                if (raf != null) {
                                    raf.close();
                                }
                                break block96;
                            }
                            catch (IOException ioe4) {
                                this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe4);
                                response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe4);
                            }
                            break block96;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_52 = null;
                        try {
                            if (raf != null) {
                                raf.close();
                            }
                        }
                        catch (IOException ioe4) {
                            this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe4);
                            response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe4);
                        }
                        throw throwable;
                    }
                }
                fos = null;
                if (file.createNewFile()) {
                    if (request.getEntity() == null) {
                        response.setStatus(Status.SUCCESS_NO_CONTENT);
                    } else {
                        fos = new FileOutputStream(file);
                        BioUtils.copy(request.getEntity().getStream(), fos);
                        response.setStatus(Status.SUCCESS_CREATED);
                    }
                    break block97;
                }
                this.getLogger().log(Level.WARNING, "Unable to create the new file");
                response.setStatus(new Status(Status.SERVER_ERROR_INTERNAL, "Unable to create the new file"));
            }
            Object var29_58 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block96;
            }
            catch (IOException ioe5) {
                this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe5);
                response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe5);
            }
            break block96;
            {
                catch (FileNotFoundException fnfe) {
                    this.getLogger().log(Level.WARNING, "Unable to create the new file", fnfe);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, fnfe);
                    Object var29_59 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block96;
                    }
                    catch (IOException ioe5) {
                        this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe5);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe5);
                    }
                    break block96;
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to create the new file", ioe);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe);
                    Object var29_60 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block96;
                    }
                    catch (IOException ioe5) {
                        this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe5);
                        response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe5);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var29_61 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ioe5) {
                    this.getLogger().log(Level.WARNING, "Unable to close the new file", ioe5);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL, ioe5);
                }
                throw throwable;
            }
        }
    }

    public boolean isResumeUpload() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("resumeUpload", "false"));
    }

    private void updateFileExtension(StringBuilder fileName, Metadata metadata) {
        boolean defaultMetadata = true;
        if (this.getMetadataService() != null) {
            if (metadata instanceof Language) {
                Language language = (Language)metadata;
                defaultMetadata = language.equals(this.getMetadataService().getDefaultLanguage());
            } else if (metadata instanceof MediaType) {
                MediaType mediaType = (MediaType)metadata;
                defaultMetadata = mediaType.equals(this.getMetadataService().getDefaultMediaType());
            } else if (metadata instanceof CharacterSet) {
                CharacterSet characterSet = (CharacterSet)metadata;
                defaultMetadata = characterSet.equals(this.getMetadataService().getDefaultCharacterSet());
            } else if (metadata instanceof Encoding) {
                Encoding encoding = (Encoding)metadata;
                defaultMetadata = encoding.equals(this.getMetadataService().getDefaultEncoding());
            }
        }
        if (!defaultMetadata) {
            String extension = this.getMetadataService().getExtension(metadata);
            if (extension != null) {
                fileName.append("." + extension);
            } else if (metadata.getParent() != null) {
                this.updateFileExtension(fileName, metadata.getParent());
            }
        }
    }
}

