/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public abstract class SecretVerifier
implements Verifier {
    public static boolean compare(char[] secret1, char[] secret2) {
        boolean result = false;
        if (secret1 == null || secret2 == null) {
            result = secret1 == secret2;
        } else if (secret1.length == secret2.length) {
            boolean equals = true;
            for (int i = 0; i < secret1.length && equals; ++i) {
                equals = secret1[i] == secret2[i];
            }
            result = equals;
        }
        return result;
    }

    protected String getIdentifier(Request request, Response response) {
        return request.getChallengeResponse().getIdentifier();
    }

    protected char[] getSecret(Request request, Response response) {
        return request.getChallengeResponse().getSecret();
    }

    public int verify(Request request, Response response) {
        int result = 4;
        if (request.getChallengeResponse() == null) {
            result = 0;
        } else {
            String identifier = this.getIdentifier(request, response);
            char[] secret = this.getSecret(request, response);
            try {
                if (this.verify(identifier, secret)) {
                    request.getClientInfo().setUser(new User(identifier));
                } else {
                    result = -1;
                }
            }
            catch (IllegalArgumentException iae) {
                result = 5;
            }
        }
        return result;
    }

    public abstract boolean verify(String var1, char[] var2) throws IllegalArgumentException;
}

