/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.engine.component.ChildClientDispatcher;
import org.restlet.engine.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildContext
extends Context {
    private volatile Restlet child = null;
    private volatile Context parentContext;

    public static void fireContextChanged(Restlet restlet, Context context) {
        if (context != null) {
            if (context instanceof ChildContext) {
                ChildContext childContext = (ChildContext)context;
                if (childContext.getChild() == null) {
                    childContext.setChild(restlet);
                }
            } else if (!(restlet instanceof Component) && context instanceof ComponentContext) {
                context.getLogger().severe("For security reasons, don't pass the component context to child Restlets anymore. Use the Context#createChildContext() method instead." + restlet.getClass());
            }
        }
    }

    public static String getBestClassName(Class<?> clazz) {
        String result = clazz.getSimpleName();
        if (result == null || result.equals("")) {
            result = ChildContext.getBestClassName(clazz.getSuperclass());
        }
        return result;
    }

    public static String getLoggerName(String baseName, Object owner) {
        String result = baseName;
        if (owner != null && owner.getClass().getSimpleName() != null) {
            result = result + "." + ChildContext.getBestClassName(owner.getClass());
        }
        return result;
    }

    public ChildContext(Context parentContext) {
        this.parentContext = parentContext;
        this.setClientDispatcher(new ChildClientDispatcher(this));
        this.setServerDispatcher(this.getParentContext() != null ? this.getParentContext().getServerDispatcher() : null);
    }

    @Override
    public Context createChildContext() {
        return new ChildContext(this);
    }

    public Restlet getChild() {
        return this.child;
    }

    protected Context getParentContext() {
        return this.parentContext;
    }

    public void setChild(Restlet child) {
        this.child = child;
        this.setLogger(ChildContext.getLoggerName(this.parentContext.getLogger().getName(), child));
    }
}

