/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.engine.Edition;
import org.restlet.engine.io.PipeStream;
import org.restlet.engine.io.ReaderInputStream;
import org.restlet.engine.io.WriterOutputStream;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.restlet.service.TaskService;

public final class BioUtils {
    private static final char[] HEXDIGITS = "0123456789ABCDEF".toCharArray();

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        inputStream.close();
    }

    public static void copy(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            randomAccessFile.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int charsRead;
        char[] buffer = new char[2048];
        while ((charsRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, charsRead);
        }
        writer.flush();
        reader.close();
    }

    public static boolean delete(File file) {
        return BioUtils.delete(file, false);
    }

    public static boolean delete(File file, boolean recursive) {
        String osName = System.getProperty("os.name").toLowerCase();
        return BioUtils.delete(file, recursive, osName.startsWith("windows"));
    }

    public static boolean delete(File file, boolean recursive, boolean garbageCollect) {
        boolean result = true;
        boolean runGC = garbageCollect;
        if (file.exists()) {
            File[] entries;
            if (file.isDirectory() && (entries = file.listFiles()).length > 0) {
                if (recursive) {
                    for (int i = 0; result && i < entries.length; ++i) {
                        if (runGC) {
                            System.gc();
                            runGC = false;
                        }
                        result = BioUtils.delete(entries[i], true, false);
                    }
                } else {
                    result = false;
                }
            }
            if (runGC) {
                System.gc();
                runGC = false;
            }
            result = result && file.delete();
        }
        return result;
    }

    public static long exhaust(InputStream input) throws IOException {
        long result = -1L;
        if (input != null) {
            byte[] buf = new byte[2048];
            int read = input.read(buf);
            long l = result = read == -1 ? -1L : 0L;
            while (read != -1) {
                result += (long)read;
                read = input.read(buf);
            }
        }
        return result;
    }

    public static Reader getReader(InputStream stream, CharacterSet characterSet) throws UnsupportedEncodingException {
        if (characterSet != null) {
            return new InputStreamReader(stream, characterSet.getName());
        }
        return new InputStreamReader(stream);
    }

    public static Reader getReader(final WriterRepresentation representation) throws IOException {
        PipedReader result = null;
        if (Edition.CURRENT != Edition.GAE) {
            final PipedWriter pipedWriter = new PipedWriter();
            PipedReader pipedReader = new PipedReader(pipedWriter);
            Application application = Application.getCurrent();
            application.getTaskService().execute(new Runnable(){

                public void run() {
                    try {
                        representation.write(pipedWriter);
                        pipedWriter.close();
                    }
                    catch (IOException ioe) {
                        Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped reader.", ioe);
                    }
                }
            });
            result = pipedReader;
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a reader for a writer representation.");
        }
        return result;
    }

    public static InputStream getStream(Reader reader, CharacterSet characterSet) {
        ReaderInputStream result = null;
        try {
            result = new ReaderInputStream(reader, characterSet);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to create the reader input stream", e);
        }
        return result;
    }

    public static InputStream getStream(final Representation representation) {
        InputStream result = null;
        if (Edition.CURRENT != Edition.GAE) {
            if (representation == null) {
                return null;
            }
            final PipeStream pipe = new PipeStream();
            Application application = Application.getCurrent();
            TaskService taskService = application == null ? new TaskService() : application.getTaskService();
            taskService.execute(new Runnable(){

                public void run() {
                    try {
                        OutputStream os = pipe.getOutputStream();
                        representation.write(os);
                        os.write(-1);
                        os.close();
                    }
                    catch (IOException ioe) {
                        Context.getCurrentLogger().log(Level.FINE, "Error while writing to the piped input stream.", ioe);
                    }
                }
            });
            result = pipe.getInputStream();
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to get an InputStream out of an OutputRepresentation.");
        }
        return result;
    }

    public static OutputStream getStream(Writer writer) {
        return new WriterOutputStream(writer);
    }

    public static byte[] toByteArray(char[] chars) {
        return BioUtils.toByteArray(chars, Charset.defaultCharset().name());
    }

    public static byte[] toByteArray(char[] chars, String charsetName) {
        CharBuffer cb = CharBuffer.wrap(chars);
        ByteBuffer bb = Charset.forName(charsetName).encode(cb);
        byte[] r = new byte[bb.remaining()];
        bb.get(r);
        return r;
    }

    public static char[] toCharArray(byte[] bytes) {
        return BioUtils.toCharArray(bytes, Charset.defaultCharset().name());
    }

    public static char[] toCharArray(byte[] bytes, String charsetName) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = Charset.forName(charsetName).decode(bb);
        char[] r = new char[cb.remaining()];
        cb.get(r);
        return r;
    }

    public static String toHexString(byte[] byteArray) {
        char[] hexChars = new char[2 * byteArray.length];
        int i = 0;
        for (byte b : byteArray) {
            hexChars[i++] = HEXDIGITS[b >> 4 & 0xF];
            hexChars[i++] = HEXDIGITS[b & 0xF];
        }
        return new String(hexChars);
    }

    public static String toString(InputStream inputStream) {
        return BioUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                result = characterSet != null ? BioUtils.toString(new InputStreamReader(inputStream, characterSet.getName())) : BioUtils.toString(new InputStreamReader(inputStream));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toString(Reader reader) {
        String result = null;
        if (reader != null) {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
                char[] buffer = new char[2048];
                int charsRead = br.read(buffer);
                while (charsRead != -1) {
                    sb.append(buffer, 0, charsRead);
                    charsRead = br.read(buffer);
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private BioUtils() {
    }
}

