/*
 * Decompiled with CFR 0.152.
 */
package org.restdoc.api;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.restdoc.api.ExampleRequest;
import org.restdoc.api.HeaderDefinition;
import org.restdoc.api.Representation;
import org.restdoc.api.ResponseDefinition;
import org.restdoc.api.util.RestDocObject;

@JsonPropertyOrder(value={"description", "statusCodes", "accepts", "headers", "response", "examples"})
public class MethodDefinition
extends RestDocObject {
    private String description;
    private final Map<String, String> statusCodes = new HashMap<String, String>();
    private final Collection<Representation> accepts = new ArrayList<Representation>();
    private final Map<String, HeaderDefinition> headers = new HashMap<String, HeaderDefinition>();
    private ResponseDefinition response;
    private final Collection<ExampleRequest> examples = new ArrayList<ExampleRequest>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getStatusCodes() {
        return this.statusCodes;
    }

    public ResponseDefinition getResponse() {
        return this.response;
    }

    public void setResponse(ResponseDefinition response) {
        this.response = response;
    }

    public Collection<Representation> getAccepts() {
        return this.accepts;
    }

    public Map<String, HeaderDefinition> getHeaders() {
        return this.headers;
    }

    public Collection<ExampleRequest> getExamples() {
        return this.examples;
    }

    public MethodDefinition description(String _description) {
        this.setDescription(_description);
        return this;
    }

    public MethodDefinition statusCode(String _code, String _description) {
        this.getStatusCodes().put(_code, _description);
        return this;
    }

    public MethodDefinition accept(String _type, String _schema) {
        this.getAccepts().add(new Representation(_type, _schema));
        return this;
    }

    public MethodDefinition header(String _name, String _description, boolean _required) {
        HeaderDefinition def = new HeaderDefinition(_description, _required);
        this.getHeaders().put(_name, def);
        return this;
    }

    public MethodDefinition response(ResponseDefinition _response) {
        this.setResponse(_response);
        return this;
    }

    public MethodDefinition example(ExampleRequest _exampleRequest) {
        this.getExamples().add(_exampleRequest);
        return this;
    }
}

