/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.web.AuthType;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BearerAuthCredentials;
import org.refcodes.web.ContentEncoding;
import org.refcodes.web.ContentType;
import org.refcodes.web.Cookie;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpFields;
import org.refcodes.web.HttpMediaType;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.MediaType;

public interface HeaderFields<C extends Cookie, B extends HeaderFields<C, B>>
extends HttpFields<B> {
    public static final String BASIC_REALM = "Basic realm";

    default public List<HttpMethod> getAllowMethods() {
        List<String> theAllows = this.get(HeaderField.ALLOW);
        if (theAllows != null && theAllows.size() != 0) {
            ArrayList<HttpMethod> theHttpMethods = new ArrayList<HttpMethod>();
            for (String eAllow : theAllows) {
                HttpMethod eHttpMethod = HttpMethod.fromHttpMethod(eAllow);
                if (eHttpMethod == null) continue;
                theHttpMethods.add(eHttpMethod);
            }
            if (theHttpMethods.size() != 0) {
                return theHttpMethods;
            }
        }
        return null;
    }

    default public List<HttpMethod> putAllowMethods(HttpMethod ... aHttpMethods) {
        if (aHttpMethods == null || aHttpMethods.length == 0) {
            return this.removeAllowMethods();
        }
        ArrayList<String> theAllows = new ArrayList<String>();
        for (HttpMethod eHttpMethod : aHttpMethods) {
            if (eHttpMethod == null) continue;
            theAllows.add(eHttpMethod.name());
        }
        if (theAllows.size() == 0) {
            return this.removeAllowMethods();
        }
        List<HttpMethod> theReturn = this.getAllowMethods();
        this.put(HeaderField.ALLOW, theAllows);
        return theReturn;
    }

    default public List<HttpMethod> putAllowMethods(List<HttpMethod> aHttpMethods) {
        if (aHttpMethods == null || aHttpMethods.size() == 0) {
            return this.removeAllowMethods();
        }
        return this.putAllowMethods(aHttpMethods.toArray(new HttpMethod[aHttpMethods.size()]));
    }

    default public B withAllowMethods(HttpMethod ... aHttpMethods) {
        this.putAllowMethods(aHttpMethods);
        return (B)this;
    }

    default public B withAllowMethods(List<HttpMethod> aHttpMethods) {
        this.putAllowMethods(aHttpMethods);
        return (B)this;
    }

    default public List<HttpMethod> removeAllowMethods() {
        List<HttpMethod> theReturn = this.getAllowMethods();
        this.remove(HeaderField.ALLOW);
        return theReturn;
    }

    default public Integer getContentLength() {
        String theContentLength = this.getFirst(HeaderField.CONTENT_LENGTH);
        if (theContentLength != null) {
            try {
                return Integer.parseInt(theContentLength);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public Integer putContentLength(Integer aContentLength) {
        if (aContentLength == null) {
            return this.removeContentLength();
        }
        Integer theReturn = this.getContentLength();
        this.put(HeaderField.CONTENT_LENGTH, aContentLength.toString());
        return theReturn;
    }

    default public B withContentLength(Integer aContentLength) {
        this.putContentLength(aContentLength);
        return (B)this;
    }

    default public Integer removeContentLength() {
        Integer theReturn = this.getContentLength();
        this.remove(HeaderField.CONTENT_LENGTH);
        return theReturn;
    }

    default public ContentType getContentType() {
        String theContentType = this.getFirst(HeaderField.CONTENT_TYPE);
        if (theContentType != null) {
            try {
                return new ContentType(theContentType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public List<String> getUnknownContentTypes() {
        List<String> theAcceptTypes = this.get(HeaderField.CONTENT_TYPE);
        if (theAcceptTypes != null && theAcceptTypes.size() != 0) {
            ArrayList<String> theUnknwonContentTypes = new ArrayList<String>();
            for (String eAcceptType : theAcceptTypes) {
                String[] eSplitMediaTypes;
                for (String eMediaType : eSplitMediaTypes = eAcceptType.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        new ContentType(eMediaType);
                    }
                    catch (IllegalArgumentException ignore) {
                        theUnknwonContentTypes.add(eMediaType);
                    }
                }
            }
            if (theUnknwonContentTypes.size() != 0) {
                return theUnknwonContentTypes;
            }
        }
        return null;
    }

    default public ContentType putContentType(HttpMediaType aHttpMediaType) {
        if (aHttpMediaType == null) {
            return this.removeContentType();
        }
        ContentType theReturn = this.getContentType();
        this.put(HeaderField.CONTENT_TYPE, aHttpMediaType.toHttpMediaType());
        return theReturn;
    }

    default public ContentType putContentType(MediaType aMediaType, Map<String, String> aParameters) {
        if (aMediaType == null) {
            return this.removeContentType();
        }
        return this.putContentType(new ContentType(aMediaType, aParameters));
    }

    default public B withContentType(HttpMediaType aHttpMediaType) {
        this.putContentType(aHttpMediaType);
        return (B)this;
    }

    default public B withContentType(MediaType aMediaType, Map<String, String> aParameters) {
        this.putContentType(aMediaType, aParameters);
        return (B)this;
    }

    default public ContentType removeContentType() {
        ContentType theReturn = this.getContentType();
        this.remove(HeaderField.CONTENT_TYPE);
        return theReturn;
    }

    default public List<ContentType> getAcceptTypes() {
        List<String> theAcceptTypes = this.get(HeaderField.ACCEPT);
        if (theAcceptTypes != null && theAcceptTypes.size() != 0) {
            ArrayList<ContentType> theContentTypes = new ArrayList<ContentType>();
            for (String eAcceptType : theAcceptTypes) {
                String[] eSplitMediaTypes;
                for (String eMediaType : eSplitMediaTypes = eAcceptType.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        theContentTypes.add(new ContentType(eMediaType));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (theContentTypes.size() != 0) {
                return theContentTypes;
            }
        }
        return null;
    }

    default public List<String> getUnknownAcceptTypes() {
        List<String> theAcceptTypes = this.get(HeaderField.ACCEPT);
        if (theAcceptTypes != null && theAcceptTypes.size() != 0) {
            ArrayList<String> theUnknwonContentTypes = new ArrayList<String>();
            for (String eAcceptType : theAcceptTypes) {
                String[] eSplitMediaTypes;
                for (String eMediaType : eSplitMediaTypes = eAcceptType.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        new ContentType(eMediaType);
                    }
                    catch (IllegalArgumentException ignore) {
                        theUnknwonContentTypes.add(eMediaType);
                    }
                }
            }
            if (theUnknwonContentTypes.size() != 0) {
                return theUnknwonContentTypes;
            }
        }
        return null;
    }

    default public List<ContentType> putAcceptTypes(HttpMediaType ... aHttpMediaType) {
        if (aHttpMediaType == null || aHttpMediaType.length == 0) {
            return this.removeAcceptTypes();
        }
        Object theAccept = "";
        for (int i = 0; i < aHttpMediaType.length; ++i) {
            if (aHttpMediaType[i] == null) continue;
            theAccept = (String)theAccept + aHttpMediaType[i].toHttpMediaType();
            if (i >= aHttpMediaType.length - 1) continue;
            theAccept = (String)theAccept + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)theAccept).isEmpty()) {
            return this.removeAcceptTypes();
        }
        List<ContentType> theReturn = this.getAcceptTypes();
        ArrayList<String> theAccepts = new ArrayList<String>();
        theAccepts.add((String)theAccept);
        this.put(HeaderField.ACCEPT, theAccepts);
        return theReturn;
    }

    default public List<ContentType> putAcceptTypes(List<? extends HttpMediaType> aHttpMediaTypes) {
        if (aHttpMediaTypes == null || aHttpMediaTypes.size() == 0) {
            return this.removeAcceptTypes();
        }
        return this.putAcceptTypes(aHttpMediaTypes.toArray(new HttpMediaType[aHttpMediaTypes.size()]));
    }

    default public B withAcceptTypes(HttpMediaType ... aHttpMediaType) {
        this.putAcceptTypes(aHttpMediaType);
        return (B)this;
    }

    default public B withAcceptTypes(List<? extends HttpMediaType> aHttpMediaType) {
        this.putAcceptTypes(aHttpMediaType);
        return (B)this;
    }

    default public List<ContentType> removeAcceptTypes() {
        List<ContentType> theReturn = this.getAcceptTypes();
        this.remove(HeaderField.ACCEPT);
        return theReturn;
    }

    default public List<String> getAcceptCharsets() {
        List<String> theAcceptCharsets = this.get(HeaderField.ACCEPT_CHARSET);
        if (theAcceptCharsets != null && theAcceptCharsets.size() != 0) {
            ArrayList<String> theCharsets = new ArrayList<String>();
            for (String eAcceptCharset : theAcceptCharsets) {
                String[] eSplitCharsets;
                for (String eCharset : eSplitCharsets = eAcceptCharset.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    if (eCharset == null || eCharset.length() <= 0) continue;
                    theCharsets.add(eCharset);
                }
            }
            if (theCharsets.size() != 0) {
                return theCharsets;
            }
        }
        return null;
    }

    default public List<String> putAcceptCharsets(String ... aAcceptCharsets) {
        if (aAcceptCharsets == null || aAcceptCharsets.length == 0) {
            return this.removeAcceptCharsets();
        }
        Object theAcceptCharset = "";
        for (int i = 0; i < aAcceptCharsets.length; ++i) {
            if (aAcceptCharsets[i] == null || aAcceptCharsets[i].length() == 0) continue;
            theAcceptCharset = (String)theAcceptCharset + aAcceptCharsets[i];
            if (i >= aAcceptCharsets.length - 1) continue;
            theAcceptCharset = (String)theAcceptCharset + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)theAcceptCharset).isEmpty()) {
            return this.removeAcceptCharsets();
        }
        List<String> theReturn = this.getAcceptCharsets();
        ArrayList<String> theAcceptCharsets = new ArrayList<String>();
        theAcceptCharsets.add((String)theAcceptCharset);
        this.put(HeaderField.ACCEPT_CHARSET, theAcceptCharsets);
        return theReturn;
    }

    default public List<String> putAcceptCharsets(List<String> aAcceptCharsets) {
        if (aAcceptCharsets == null || aAcceptCharsets.size() == 0) {
            return this.removeAcceptCharsets();
        }
        return this.putAcceptCharsets(aAcceptCharsets.toArray(new String[aAcceptCharsets.size()]));
    }

    default public B withAcceptCharsets(List<String> aAcceptCharsets) {
        this.putAcceptCharsets(aAcceptCharsets);
        return (B)this;
    }

    default public B withAcceptCharsets(String ... aAcceptCharsets) {
        this.putAcceptCharsets(aAcceptCharsets);
        return (B)this;
    }

    default public List<String> removeAcceptCharsets() {
        List<String> theReturn = this.getAcceptCharsets();
        this.remove(HeaderField.ACCEPT_CHARSET);
        return theReturn;
    }

    default public List<ContentEncoding> getAcceptEncodings() {
        List<String> theAcceptEncodings = this.get(HeaderField.ACCEPT_ENCODING);
        if (theAcceptEncodings != null && theAcceptEncodings.size() != 0) {
            ArrayList<ContentEncoding> theContentEncodings = new ArrayList<ContentEncoding>();
            for (String eAcceptEncoding : theAcceptEncodings) {
                String[] eSplitEncodings;
                for (String eContentEncoding : eSplitEncodings = eAcceptEncoding.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        theContentEncodings.add(ContentEncoding.fromHttpEncoding(eContentEncoding));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (theContentEncodings.size() != 0) {
                return theContentEncodings;
            }
        }
        return null;
    }

    default public List<ContentEncoding> putAcceptEncodings(ContentEncoding ... aEncodings) {
        if (aEncodings == null || aEncodings.length == 0) {
            return this.removeAcceptEncodings();
        }
        Object theAcceptEncoding = "";
        for (int i = 0; i < aEncodings.length; ++i) {
            if (aEncodings[i] == null) continue;
            theAcceptEncoding = (String)theAcceptEncoding + aEncodings[i].getName();
            if (i >= aEncodings.length - 1) continue;
            theAcceptEncoding = (String)theAcceptEncoding + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)theAcceptEncoding).isEmpty()) {
            return this.removeAcceptEncodings();
        }
        List<ContentEncoding> theReturn = this.getAcceptEncodings();
        ArrayList<String> theAcceptEncodings = new ArrayList<String>();
        theAcceptEncodings.add((String)theAcceptEncoding);
        this.put(HeaderField.ACCEPT_ENCODING, theAcceptEncodings);
        return theReturn;
    }

    default public List<ContentEncoding> putAcceptEncodings(List<ContentEncoding> aEncodings) {
        if (aEncodings == null || aEncodings.size() == 0) {
            return this.removeAcceptEncodings();
        }
        return this.putAcceptEncodings(aEncodings.toArray(new ContentEncoding[aEncodings.size()]));
    }

    default public B withAcceptEncodings(ContentEncoding ... aEncodings) {
        this.putAcceptEncodings(aEncodings);
        return (B)this;
    }

    default public B withAcceptEncodings(List<ContentEncoding> aEncodings) {
        this.putAcceptEncodings(aEncodings);
        return (B)this;
    }

    default public List<ContentEncoding> removeAcceptEncodings() {
        List<ContentEncoding> theReturn = this.getAcceptEncodings();
        this.remove(HeaderField.ACCEPT_ENCODING);
        return theReturn;
    }

    default public List<Locale> getAcceptLanguages() {
        List<String> theAcceptLanguages = this.get(HeaderField.ACCEPT_LANGUAGE);
        if (theAcceptLanguages != null && theAcceptLanguages.size() != 0) {
            ArrayList<Locale> theLocales = new ArrayList<Locale>();
            for (String eAcceptLanguage : theAcceptLanguages) {
                String[] eSplitEncodings;
                for (String eLocale : eSplitEncodings = eAcceptLanguage.split("" + Delimiter.HTTP_HEADER_ELEMENTS.getChar())) {
                    try {
                        theLocales.add(Locale.forLanguageTag(eLocale));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (theLocales.size() != 0) {
                return theLocales;
            }
        }
        return null;
    }

    default public List<Locale> putAcceptLanguages(Locale ... aLanguages) {
        if (aLanguages == null || aLanguages.length == 0) {
            return this.removeAcceptLanguages();
        }
        Object theAcceptLanguage = "";
        for (int i = 0; i < aLanguages.length; ++i) {
            if (aLanguages[i] == null) continue;
            theAcceptLanguage = (String)theAcceptLanguage + (aLanguages[i].getLanguage() != null ? aLanguages[i].getLanguage() : "");
            theAcceptLanguage = (String)theAcceptLanguage + (aLanguages[i].getLanguage() != null && aLanguages[i].getCountry() != null && aLanguages[i].getCountry().length() != 0 ? "-" : "");
            theAcceptLanguage = (String)theAcceptLanguage + (aLanguages[i].getCountry() != null ? aLanguages[i].getCountry() : "");
            if (i >= aLanguages.length - 1) continue;
            theAcceptLanguage = (String)theAcceptLanguage + Delimiter.HTTP_HEADER_ELEMENTS.getChar();
        }
        if (((String)theAcceptLanguage).isEmpty()) {
            return this.removeAcceptLanguages();
        }
        List<Locale> theReturn = this.getAcceptLanguages();
        ArrayList<String> theAcceptLanguages = new ArrayList<String>();
        theAcceptLanguages.add((String)theAcceptLanguage);
        this.put(HeaderField.ACCEPT_LANGUAGE, theAcceptLanguages);
        return theReturn;
    }

    default public List<Locale> putAcceptLanguages(List<Locale> aLanguages) {
        if (aLanguages == null || aLanguages.size() == 0) {
            return this.removeAcceptLanguages();
        }
        return this.putAcceptLanguages(aLanguages.toArray(new Locale[aLanguages.size()]));
    }

    default public B withAcceptLanguages(Locale ... aLanguages) {
        this.putAcceptLanguages(aLanguages);
        return (B)this;
    }

    default public B withAcceptLanguages(List<Locale> aLanguages) {
        this.putAcceptLanguages(aLanguages);
        return (B)this;
    }

    default public List<Locale> removeAcceptLanguages() {
        List<Locale> theReturn = this.getAcceptLanguages();
        this.remove(HeaderField.ACCEPT_LANGUAGE);
        return theReturn;
    }

    default public ContentEncoding getContentEncoding() {
        String theContentType = this.getFirst(HeaderField.CONTENT_ENCODING);
        if (theContentType != null) {
            return ContentEncoding.fromHttpEncoding(theContentType);
        }
        return null;
    }

    default public ContentEncoding putContentEncoding(ContentEncoding aEncoding) {
        if (aEncoding == null) {
            return this.removeContentEncoding();
        }
        ContentEncoding theReturn = this.getContentEncoding();
        this.put(HeaderField.CONTENT_ENCODING, aEncoding.getName());
        return theReturn;
    }

    default public B withContentEncoding(ContentEncoding aEncoding) {
        this.putContentEncoding(aEncoding);
        return (B)this;
    }

    default public ContentEncoding removeContentEncoding() {
        ContentEncoding theReturn = this.getContentEncoding();
        this.remove(HeaderField.CONTENT_ENCODING);
        return theReturn;
    }

    default public String getUserAgent() {
        return this.getFirst(HeaderField.USER_AGENT);
    }

    default public String putUserAgent(String aUserAgent) {
        if (aUserAgent == null || aUserAgent.isEmpty()) {
            return this.removeUserAgent();
        }
        String theReturn = this.getUserAgent();
        this.put(HeaderField.USER_AGENT, aUserAgent);
        return theReturn;
    }

    default public B withUserAgent(String aUserAgent) {
        this.putUserAgent(aUserAgent);
        return (B)this;
    }

    default public String removeUserAgent() {
        String theReturn = this.getUserAgent();
        this.remove(HeaderField.USER_AGENT);
        return theReturn;
    }

    default public String getHost() {
        return this.getFirst(HeaderField.HOST);
    }

    default public String putHost(String aHost) {
        if (aHost == null || aHost.isEmpty()) {
            return this.removeHost();
        }
        String theReturn = this.getHost();
        this.put(HeaderField.HOST, aHost);
        return theReturn;
    }

    default public B withHost(String aHost) {
        this.putHost(aHost);
        return (B)this;
    }

    default public String removeHost() {
        String theReturn = this.getHost();
        this.remove(HeaderField.HOST);
        return theReturn;
    }

    default public String getRequestId() {
        return this.getFirst(HeaderField.REQUEST_ID);
    }

    default public String putRequestId(String aRequestId) {
        if (aRequestId == null || aRequestId.isEmpty()) {
            return this.removeRequestId();
        }
        String theReturn = this.getRequestId();
        this.put(HeaderField.REQUEST_ID, aRequestId);
        return theReturn;
    }

    default public B withRequestId(String aRequestId) {
        this.putRequestId(aRequestId);
        return (B)this;
    }

    default public String removeRequestId() {
        String theReturn = this.getRequestId();
        this.remove(HeaderField.REQUEST_ID);
        return theReturn;
    }

    default public String getSessionId() {
        return this.getFirst(HeaderField.SESSION_ID);
    }

    default public String putSessionId(String aSessionId) {
        if (aSessionId == null || aSessionId.isEmpty()) {
            return this.removeSessionId();
        }
        String theReturn = this.getSessionId();
        this.put(HeaderField.SESSION_ID, aSessionId);
        return theReturn;
    }

    default public B withSessionId(String aSessionId) {
        this.putSessionId(aSessionId);
        return (B)this;
    }

    default public String removeSessionId() {
        String theReturn = this.getSessionId();
        this.remove(HeaderField.SESSION_ID);
        return theReturn;
    }

    default public String getAuthenticate() {
        return this.getFirst(HeaderField.WWW_AUTHENTICATE);
    }

    default public String putAuthenticate(String aAuthenticate) {
        if (aAuthenticate == null || aAuthenticate.isEmpty()) {
            return this.removeAuthenticate();
        }
        String theReturn = this.getAuthenticate();
        this.put(HeaderField.WWW_AUTHENTICATE, aAuthenticate);
        return theReturn;
    }

    default public B withAuthenticate(String aAuthenticate) {
        this.putAuthenticate(aAuthenticate);
        return (B)this;
    }

    default public String removeAuthenticate() {
        String theReturn = this.getAuthenticate();
        this.remove(HeaderField.WWW_AUTHENTICATE);
        return theReturn;
    }

    default public String getBasicAuth() {
        String theReturn = this.getFirst(HeaderField.WWW_AUTHENTICATE);
        if (theReturn != null && theReturn.startsWith(BASIC_REALM)) {
            return theReturn;
        }
        return null;
    }

    default public String putBasicAuthRequired(String aRealm) {
        if (aRealm == null) {
            return this.removeBasicAuthenticate();
        }
        String theReturn = this.getBasicAuth();
        this.put(HeaderField.WWW_AUTHENTICATE.getName(), "Basic realm=\"" + aRealm + "\"");
        return theReturn;
    }

    default public B withBasicAuthRequired(String aRealm) {
        this.putBasicAuthRequired(aRealm);
        return (B)this;
    }

    default public String removeBasicAuthenticate() {
        String theReturn = this.getBasicAuth();
        if (theReturn != null) {
            this.remove(HeaderField.WWW_AUTHENTICATE);
        }
        return theReturn;
    }

    default public String toBasicAuthRealm() {
        String theReturn = this.getAuthenticate();
        if (theReturn != null) {
            String theRealmPrefix = "Basic realm=\"";
            if (theReturn.startsWith("Basic realm=\"") && (theReturn = theReturn.substring("Basic realm=\"".length())).endsWith("\"")) {
                theReturn = theReturn.substring(0, theReturn.length() - 1);
            }
        }
        return theReturn;
    }

    default public String getAuthorization() {
        return this.getFirst(HeaderField.AUTHORIZATION);
    }

    default public String putAuthorization(String aAuthType, String aAuthorize) {
        if ((aAuthorize == null || aAuthorize.isEmpty()) && (aAuthType == null || aAuthType.isEmpty())) {
            return this.removeAuthorization();
        }
        String theReturn = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, aAuthType + " " + aAuthorize);
        return theReturn;
    }

    default public B withAuthorization(String aAuthType, String aAuthorize) {
        this.putAuthorization(aAuthType, aAuthorize);
        return (B)this;
    }

    default public String putAuthorization(AuthType aAuthType, String aAuthorize) {
        if ((aAuthorize == null || aAuthorize.isEmpty()) && aAuthType == null) {
            return this.removeAuthorization();
        }
        String theReturn = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, aAuthType.getName() + " " + aAuthorize);
        return theReturn;
    }

    default public B withAuthorization(AuthType aAuthType, String aAuthorize) {
        this.putAuthorization(aAuthType, aAuthorize);
        return (B)this;
    }

    default public String putAuthorization(String aAuthorize) {
        if (aAuthorize == null || aAuthorize.isEmpty()) {
            return this.removeAuthorization();
        }
        String theReturn = this.getAuthorization();
        this.put(HeaderField.AUTHORIZATION, aAuthorize);
        return theReturn;
    }

    default public B withAuthorization(String aAuthorize) {
        this.putAuthorization(aAuthorize);
        return (B)this;
    }

    default public String removeAuthorization() {
        String theReturn = this.getAuthorization();
        this.remove(HeaderField.AUTHORIZATION);
        return theReturn;
    }

    default public BearerAuthCredentials getBearerAuthCredentials() {
        String theValue = this.getFirst(HeaderField.AUTHORIZATION);
        if (theValue != null) {
            try {
                return new BearerAuthCredentials().withHttpAuthorization(theValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public BearerAuthCredentials putBearerAuthCredentials(String aBearerAuthCredentials) {
        return this.putBearerAuthCredentials(new BearerAuthCredentials(aBearerAuthCredentials));
    }

    default public BearerAuthCredentials putBearerAuthCredentials(BearerAuthCredentials aBearerAuthCredentials) {
        if (aBearerAuthCredentials == null) {
            return this.removeBearerAuthCredentials();
        }
        BearerAuthCredentials theReturn = this.getBearerAuthCredentials();
        this.put(HeaderField.AUTHORIZATION, aBearerAuthCredentials.toHttpAuthorization());
        return theReturn;
    }

    default public B withBearerAuthCredentials(BearerAuthCredentials aBearerAuthCredentials) {
        this.putBearerAuthCredentials(aBearerAuthCredentials);
        return (B)this;
    }

    default public B withBearerAuthCredentials(String aToken) {
        this.putBearerAuthCredentials(aToken);
        return (B)this;
    }

    default public BearerAuthCredentials removeBearerAuthCredentials() {
        BearerAuthCredentials theReturn = this.getBearerAuthCredentials();
        if (theReturn != null) {
            this.remove(HeaderField.AUTHORIZATION);
        }
        return theReturn;
    }

    default public BasicAuthCredentials getBasicAuthCredentials() {
        String theValue = this.getFirst(HeaderField.AUTHORIZATION);
        if (theValue != null) {
            try {
                return new BasicAuthCredentials().withHttpAuthorization(theValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    default public BasicAuthCredentials putBasicAuthCredentials(String aUserName, String aSecret) {
        return this.putBasicAuthCredentials(new BasicAuthCredentials(aUserName, aSecret));
    }

    default public BasicAuthCredentials putBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        if (aBasicAuthCredentials == null) {
            return this.removeBasicAuthCredentials();
        }
        BasicAuthCredentials theReturn = this.getBasicAuthCredentials();
        this.put(HeaderField.AUTHORIZATION, aBasicAuthCredentials.toHttpAuthorization());
        return theReturn;
    }

    default public B withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this.putBasicAuthCredentials(aBasicAuthCredentials);
        return (B)this;
    }

    default public B withBasicAuthCredentials(String aUserName, String aSecret) {
        this.putBasicAuthCredentials(aUserName, aSecret);
        return (B)this;
    }

    default public BasicAuthCredentials removeBasicAuthCredentials() {
        BasicAuthCredentials theReturn = this.getBasicAuthCredentials();
        if (theReturn != null) {
            this.remove(HeaderField.AUTHORIZATION);
        }
        return theReturn;
    }

    default public List<String> get(HeaderField aHeaderField) {
        return (List)this.get(aHeaderField.getName());
    }

    default public String getFirst(HeaderField aHeaderField) {
        return this.getFirst(aHeaderField.getName());
    }

    default public void addTo(HeaderField aHeaderField, String aValue) {
        this.addTo(aHeaderField.getName(), aValue);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField aHeaderField, String aValue) {
        return (HeaderFields)this.withAddTo(aHeaderField.getName(), aValue);
    }

    default public void addTo(HeaderField aHeaderField, String ... aValues) {
        this.addTo(aHeaderField.getName(), aValues);
    }

    default public void addTo(HeaderField aHeaderField, List<String> aValues) {
        this.addTo(aHeaderField.getName(), aValues);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField aHeaderField, String ... aValues) {
        return (HeaderFields)this.withAddTo(aHeaderField.getName(), aValues);
    }

    default public HeaderFields<C, B> withAddTo(HeaderField aHeaderField, List<String> aValues) {
        return (HeaderFields)this.withAddTo(aHeaderField.getName(), aValues);
    }

    @Override
    default public List<String> put(HeaderField aHeaderField, String aValue) {
        return this.put(aHeaderField.getName(), aValue);
    }

    default public HeaderFields<C, B> withPut(HeaderField aHeaderField, String aValue) {
        return (HeaderFields)this.withPut(aHeaderField.getName(), aValue);
    }

    @Override
    default public List<String> put(HeaderField aHeaderField, String ... aValues) {
        return this.put(aHeaderField.getName(), aValues);
    }

    @Override
    default public List<String> put(HeaderField aHeaderField, List<String> aValues) {
        return this.put(aHeaderField.getName(), aValues);
    }

    default public HeaderFields<C, B> withPut(HeaderField aHeaderField, String ... aValues) {
        return (HeaderFields)this.withPut(aHeaderField.getName(), aValues);
    }

    default public HeaderFields<C, B> withPut(HeaderField aHeaderField, List<String> aValues) {
        return (HeaderFields)this.withPut(aHeaderField.getName(), aValues);
    }

    default public List<String> remove(HeaderField aHeaderField) {
        return (List)this.remove(aHeaderField.getName());
    }

    public C addCookie(String var1);

    public C addCookie(String var1, String var2);

    public C addCookie(C var1);

    default public HeaderFields<C, B> withAddCookie(String aCookieName, String aValue) {
        this.addCookie(aCookieName, aValue);
        return this;
    }

    default public HeaderFields<C, B> withAddCookie(C aCookie) {
        this.addCookie(aCookie);
        return this;
    }

    public List<C> getAllCookies();

    default public List<C> getCookies(String aCookieName) {
        List<C> theCookies = this.getAllCookies();
        ArrayList<Cookie> theResult = new ArrayList<Cookie>();
        for (Cookie eCookie : theCookies) {
            if (!aCookieName.equals(eCookie.getKey())) continue;
            theResult.add(eCookie);
        }
        return theResult;
    }

    default public C getFirstCookie(String aCookieName) {
        List<C> theCookies = this.getCookies(aCookieName);
        if (theCookies != null && !theCookies.isEmpty()) {
            return (C)((Cookie)theCookies.get(0));
        }
        return null;
    }

    default public String[] toHttpCookies() {
        ArrayList<String> theHttpCookies = new ArrayList<String>();
        List<C> theCookies = this.getAllCookies();
        if (theCookies == null) {
            return null;
        }
        for (Cookie eCookie : theCookies) {
            theHttpCookies.add(eCookie.toHttpCookie());
        }
        return theHttpCookies.toArray(new String[theHttpCookies.size()]);
    }

    default public void toHeaderFields(Map<String, List<String>> aToFields) {
        for (String eKey : this.keySet()) {
            aToFields.put(eKey, (List)this.get(eKey));
        }
    }
}

