/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.FillCharAccessor;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.HorizAlignTextModeAccessor;

public class HorizAlignTextBuilder
extends AbstractText<HorizAlignTextBuilder>
implements FillCharAccessor.FillCharProperty,
FillCharAccessor.FillCharBuilder<HorizAlignTextBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<HorizAlignTextBuilder>,
ColumnWidthAccessor.ColumnWidthProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeBuilder<HorizAlignTextBuilder> {
    private int _columnWidth = Terminal.toHeuristicWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private char _fillChar = (char)32;

    public HorizAlignTextBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._alignTextMode = aHorizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char aFillChar) {
        this._fillChar = aFillChar;
    }

    @Override
    public String[] toStrings() {
        return HorizAlignTextBuilder.asAligned(this.getText(), this._columnWidth, this._fillChar, this._alignTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return HorizAlignTextBuilder.asAligned(aText, this._columnWidth, this._fillChar, this._alignTextMode);
    }

    @Override
    public HorizAlignTextBuilder withHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.setHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public HorizAlignTextBuilder withFillChar(char aFillChar) {
        this.setFillChar(aFillChar);
        return this;
    }

    public static String asAligned(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, ' ', aHorizAlignTextMode, false);
    }

    public static String asAligned(String aText, int aColumnWidth, char aFillChar, HorizAlignTextMode aHorizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, aHorizAlignTextMode, false);
    }

    public static String[] asAligned(String[] aText, int aColumnWidth, char aFillChar, HorizAlignTextMode aHorizAlignTextMode) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, aHorizAlignTextMode, false);
    }

    public static String asAligned(String aText, int aColumnWidth, HorizAlignTextMode aHorizAlignTextMode, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, ' ', aHorizAlignTextMode, hasAnsiEscapeCodes);
    }

    public static String asAligned(String aText, int aColumnWidth, char aFillChar, HorizAlignTextMode aHorizAlignTextMode, boolean hasAnsiEscapeCodes) {
        if (aHorizAlignTextMode == null) {
            return aText;
        }
        switch (aHorizAlignTextMode) {
            case BLOCK: {
                return HorizAlignTextBuilder.toAlignBlock(aText, aColumnWidth, aFillChar, hasAnsiEscapeCodes);
            }
            case CENTER: {
                return HorizAlignTextBuilder.toAlignCenter(aText, aColumnWidth, aFillChar, hasAnsiEscapeCodes);
            }
            case LEFT: {
                return HorizAlignTextBuilder.toAlignLeft(aText, aColumnWidth, aFillChar, hasAnsiEscapeCodes);
            }
            case RIGHT: {
                return HorizAlignTextBuilder.toAlignRight(aText, aColumnWidth, aFillChar, hasAnsiEscapeCodes);
            }
        }
        throw new IllegalArgumentException("You must provide a supported value for the horizontal align mode, though you provided <" + String.valueOf((Object)aHorizAlignTextMode) + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }

    public static String[] asAligned(String[] aText, int aColumnWidth, char aFillChar, HorizAlignTextMode aHorizAlignTextMode, boolean hasAnsiEscapeCodes) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = HorizAlignTextBuilder.asAligned(aText[i], aColumnWidth, aFillChar, aHorizAlignTextMode, hasAnsiEscapeCodes);
        }
        return theResult;
    }

    public static String asLeftAligned(String aText, int aColumnWidth) {
        return HorizAlignTextBuilder.asLeftAligned(aText, aColumnWidth, ' ', false);
    }

    public static String asLeftAligned(String aText, int aColumnWidth, char aFillChar) {
        return HorizAlignTextBuilder.asLeftAligned(aText, aColumnWidth, aFillChar, false);
    }

    public static String[] asLeftAligned(String[] aText, int aColumnWidth, char aFillChar) {
        return HorizAlignTextBuilder.asLeftAligned(aText, aColumnWidth, aFillChar, false);
    }

    public static String asLeftAligned(String aText, int aColumnWidth, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asLeftAligned(aText, aColumnWidth, ' ', hasAnsiEscapeCodes);
    }

    public static String asLeftAligned(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, HorizAlignTextMode.LEFT, hasAnsiEscapeCodes);
    }

    public static String[] asLeftAligned(String[] aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, HorizAlignTextMode.LEFT, hasAnsiEscapeCodes);
    }

    public static String asRightAligned(String aText, int aColumnWidth) {
        return HorizAlignTextBuilder.asRightAligned(aText, aColumnWidth, ' ', false);
    }

    public static String asRightAligned(String aText, int aColumnWidth, char aFillChar) {
        return HorizAlignTextBuilder.asRightAligned(aText, aColumnWidth, aFillChar, false);
    }

    public static String[] asRightAligned(String[] aText, int aColumnWidth, char aFillChar) {
        return HorizAlignTextBuilder.asRightAligned(aText, aColumnWidth, aFillChar, false);
    }

    public static String asRightAligned(String aText, int aColumnWidth, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asRightAligned(aText, aColumnWidth, ' ', hasAnsiEscapeCodes);
    }

    public static String asRightAligned(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, HorizAlignTextMode.RIGHT, hasAnsiEscapeCodes);
    }

    public static String[] asRightAligned(String[] aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        return HorizAlignTextBuilder.asAligned(aText, aColumnWidth, aFillChar, HorizAlignTextMode.RIGHT, hasAnsiEscapeCodes);
    }

    private static String toAlignLeft(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) == aColumnWidth) {
            return aText;
        }
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aColumnWidth) {
            return aText.substring(0, aColumnWidth);
        }
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aText);
        for (int i = 0; i < aColumnWidth - HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes); ++i) {
            theBuffer.append(aFillChar);
        }
        return theBuffer.toString();
    }

    private static String toAlignRight(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) == aColumnWidth) {
            return aText;
        }
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aColumnWidth) {
            return aText.substring(HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) - aColumnWidth);
        }
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aColumnWidth - HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes); ++i) {
            theBuffer.append(aFillChar);
        }
        theBuffer.append(aText);
        return theBuffer.toString();
    }

    private static String toAlignCenter(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) == aColumnWidth) {
            return aText;
        }
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aColumnWidth) {
            int theExceed = HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) - aColumnWidth;
            int theLeft = theExceed / 2;
            int theRight = theExceed / 2;
            return aText.substring(theLeft, HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) - (theRight += theExceed % 2));
        }
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aText);
        while (theBuffer.length() < aColumnWidth) {
            theBuffer.append(aFillChar);
            if (theBuffer.length() >= aColumnWidth) continue;
            theBuffer.insert(0, aFillChar);
        }
        return theBuffer.toString();
    }

    private static String toAlignBlock(String aText, int aColumnWidth, char aFillChar, boolean hasAnsiEscapeCodes) {
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) == aColumnWidth) {
            return aText;
        }
        if (HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) > aColumnWidth) {
            int theExceed = HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) - aColumnWidth;
            int theLeft = theExceed / 2;
            int theRight = theExceed / 2;
            return aText.substring(theLeft, HorizAlignTextBuilder.toLength(aText, hasAnsiEscapeCodes) - (theRight += theExceed % 2));
        }
        if (aText.indexOf(aFillChar) == -1) {
            return HorizAlignTextBuilder.toAlignLeft(aText, aColumnWidth, aFillChar, hasAnsiEscapeCodes);
        }
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aText);
        String theFillChar = new String(new char[]{aFillChar});
        int eOffset = -1;
        while (theBuffer.length() < aColumnWidth) {
            if ((eOffset = theBuffer.indexOf(theFillChar, eOffset + 1)) == -1) {
                eOffset = 0;
                continue;
            }
            theBuffer.insert(eOffset, theFillChar);
            while (eOffset < theBuffer.length() - 1 && theBuffer.charAt(eOffset) == aFillChar) {
                ++eOffset;
            }
            if (eOffset <= aColumnWidth) continue;
            eOffset = 0;
        }
        return theBuffer.toString();
    }

    private static int toLength(String aText, boolean hasAnsiEscapeCodes) {
        if (hasAnsiEscapeCodes) {
            return AnsiEscapeCode.toUnescapedLength((String)aText);
        }
        return aText.length();
    }
}

