/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.PathComparator;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.struct.ext.factory.AbstractCanonicalMapFactory;
import org.refcodes.struct.ext.factory.DocumentProperty;

public class TomlCanonicalMapFactory
extends AbstractCanonicalMapFactory {
    public static final char SECTION_BEGIN = '[';
    public static final char SECTION_END = ']';
    public static final char[] COMMENTS = new char[]{'#', ';'};
    private static final String RESET_SECTION = "---";
    public static final char[] DELIMITERS = new char[]{'/', '.'};

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation) throws UnmarshalException {
        return this.fromMarshaled(aExternalRepresentation, null);
    }

    public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
        CanonicalMapBuilderImpl canonicalMapBuilderImpl;
        char theDelimiter = DocumentProperty.toDelimiter(aProperties, PathMap.DELIMITER);
        char[] theSupportedDelimiters = DocumentProperty.toDelimiters(aProperties);
        BufferedReader theReader = new BufferedReader(new InputStreamReader(aExternalRepresentation));
        try {
            Stack<String> theSections = new Stack<String>();
            int eLineNum = 0;
            CanonicalMapBuilderImpl theResult = new CanonicalMapBuilderImpl(theDelimiter);
            while (theReader.ready()) {
                ++eLineNum;
                String eLine = theReader.readLine();
                String eTruncated = eLine.replaceAll("^\\s+", "");
                boolean isStartComment = false;
                for (char eChar : COMMENTS) {
                    if (!eTruncated.startsWith("" + eChar)) continue;
                    isStartComment = true;
                    break;
                }
                if (isStartComment || (eTruncated = eLine.trim()).length() <= 0) continue;
                int eLevel = this.getLevel(eTruncated);
                if (eLevel > 0) {
                    eTruncated = eTruncated.substring(eLevel, eTruncated.length() - eLevel);
                    if (theSupportedDelimiters != null && theSupportedDelimiters.length != 0) {
                        for (char eDelimiter : theSupportedDelimiters) {
                            if (eDelimiter == theResult.getDelimiter()) continue;
                            eTruncated = eTruncated.replace(eDelimiter, theResult.getDelimiter());
                        }
                    }
                    while (theSections.size() >= eLevel) {
                        theSections.pop();
                    }
                    if (theSections.size() + 1 < eLevel) {
                        throw new UnmarshalException("The line '" + eLine + "' is of a wrong section nesting (number of opening '[' and closing ']' section identifiers) of <" + eLevel + ">, though expected a section nesting of <" + (theSections.size() + 1) + ">", eLineNum);
                    }
                    theSections.push(eTruncated);
                    continue;
                }
                if (RESET_SECTION.equals(eTruncated)) {
                    theSections.clear();
                    continue;
                }
                if (!eLine.contains("" + Delimiter.PROPERTY.getChar())) {
                    throw new UnmarshalException("Expected a '" + Delimiter.PROPERTY.getChar() + "' at line <" + eLineNum + ">, line cannot be parsed as property.", eLineNum);
                }
                PropertyImpl eProperty = new PropertyImpl(eLine);
                if (((String)eProperty.getKey()).contains(" ")) {
                    throw new UnmarshalException("The key \"" + (String)eProperty.getKey() + "\" contains a space \" \" at line <" + eLineNum + ">, a key must not contain spaces.", eLineNum);
                }
                eTruncated = ((String)eProperty.getKey()).trim();
                eTruncated = theResult.fromExternalPath(eTruncated, theSupportedDelimiters);
                theResult.put((Object)theResult.toPath(new String[]{this.toSectionsPath(theSections, (CanonicalMap)theResult), eTruncated}), (Object)((String)eProperty.getValue()));
            }
            canonicalMapBuilderImpl = theResult;
        }
        catch (Throwable throwable) {
            try {
                try {
                    theReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aExternalRepresentation) + ">!", (Throwable)e);
            }
            catch (ParseException e) {
                throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aExternalRepresentation) + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset(), (Throwable)e);
            }
        }
        theReader.close();
        return canonicalMapBuilderImpl;
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.toMarshaled(aDataStructure, null);
    }

    @Override
    public String toMarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String eExternalKey;
        char theDelimiter = DocumentProperty.toDelimiter(aProperties, aDataStructure.getDelimiter());
        ArrayList theGlobals = new ArrayList(aDataStructure.leaves());
        PathComparator thePathComparator = new PathComparator(aDataStructure.getDelimiter());
        theGlobals.sort(thePathComparator);
        ArrayList theSections = new ArrayList(aDataStructure.dirs());
        theSections.sort(thePathComparator);
        boolean hasWritten = false;
        Object theResult = "";
        String theComment = DocumentProperty.toComment(aProperties);
        if (theComment != null && theComment.length() > 0) {
            String[] theLines = theComment.split("\\r?\\n");
            for (String eLine : theLines) {
                theResult = (String)theResult + COMMENTS[0] + " " + (String)eLine;
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        if (theGlobals != null && !theGlobals.isEmpty()) {
            if (hasWritten) {
                theResult = (String)theResult + System.lineSeparator();
            }
            for (String eKey : theGlobals) {
                eExternalKey = aDataStructure.toExternalPath(eKey, theDelimiter);
                theResult = (String)theResult + eExternalKey + Delimiter.PROPERTY.getChar() + (String)aDataStructure.get((Object)eKey);
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        for (String eKey : theSections) {
            if (hasWritten) {
                theResult = (String)theResult + System.lineSeparator();
            }
            theResult = (String)theResult + "[" + eKey + "]";
            theResult = (String)theResult + System.lineSeparator();
            theResult = (String)theResult + System.lineSeparator();
            CanonicalMap eSecionProperties = aDataStructure.retrieveFrom(eKey);
            ArrayList eSectionKeys = new ArrayList(eSecionProperties.keySet());
            eSectionKeys.sort(thePathComparator);
            for (String eSectionKey : eSectionKeys) {
                eExternalKey = aDataStructure.toExternalPath(eSectionKey, theDelimiter);
                eExternalKey = aDataStructure.toPropertyPath(eExternalKey);
                theResult = (String)theResult + eExternalKey + Delimiter.PROPERTY.getChar() + (String)eSecionProperties.get((Object)eSectionKey);
                theResult = (String)theResult + System.lineSeparator();
            }
            hasWritten = true;
        }
        return theResult;
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure) throws MarshalException {
        return this.fromUnmarshaled(aDataStructure, null);
    }

    public InputStream fromUnmarshaled(CanonicalMap aDataStructure, Map<String, String> aProperties) throws MarshalException {
        String theExternalRepresentation = this.toMarshaled(aDataStructure, aProperties);
        return this.toInputStream(theExternalRepresentation);
    }

    private String toSectionsPath(Stack<String> aSections, CanonicalMap aDataStructure) {
        String[] theSections = aSections.toArray(new String[aSections.size()]);
        for (int i = 0; i < theSections.length; ++i) {
            theSections[i] = aDataStructure.fromExternalPath(theSections[i], DELIMITERS);
        }
        return aDataStructure.toPath(theSections);
    }

    private int getLevel(String aLine) throws ParseException {
        String theLine = aLine;
        int theLeft = 0;
        int theRight = 0;
        while (theLine.startsWith("[")) {
            theLine = theLine.substring(1);
            ++theLeft;
        }
        while (theLine.endsWith("]")) {
            theLine = theLine.substring(0, theLine.length() - 1);
            ++theRight;
        }
        if (theLeft != theRight) {
            throw new ParseException("The line '" + aLine + "' starts with <" + theLeft + "> '[' chars, though ends with <" + theRight + "> ']' chars. It must start with as many '[' chars as it ends with ']' chars.", theLeft);
        }
        return theLeft;
    }
}

