/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.ext.factory.CanonicalMapFactory;

public abstract class AbstractCanonicalMapFactory
implements CanonicalMapFactory {
    static final String INDEX_ATTRIBUTE = "index";
    static final String[] THIS_ATTRIBUTES = new String[]{"this", ".", "_"};

    protected void postProcess(CanonicalMap.CanonicalMapBuilder aProperties) {
        HashSet theKeys = new HashSet(aProperties.keySet());
        for (String ePrefix : new String[]{"", "" + aProperties.getAnnotator()}) {
            for (String eAttribute : THIS_ATTRIBUTES) {
                String theAttributeSuffix = aProperties.getDelimiter() + ePrefix + eAttribute;
                for (String eKey : theKeys) {
                    String ePropertyKey;
                    String ePropertyValue;
                    String eValue;
                    if (!eKey.endsWith(theAttributeSuffix) || (eValue = (String)aProperties.get((Object)eKey)) == null || eValue.length() == 0 || (ePropertyValue = (String)aProperties.get((Object)(ePropertyKey = eKey.substring(0, eKey.length() - theAttributeSuffix.length())))) != null && ePropertyValue.length() != 0) continue;
                    aProperties.put((Object)ePropertyKey, (Object)eValue);
                    aProperties.remove((Object)eKey);
                }
            }
        }
    }

    protected String toString(InputStream aInputStream) throws IOException {
        int eRead;
        ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
        byte[] theData = new byte[16384];
        while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
            theBuffer.write(theData, 0, eRead);
        }
        theBuffer.flush();
        return theBuffer.toString();
    }

    protected InputStream toInputStream(String aString) {
        return new ByteArrayInputStream(aString.getBytes(StandardCharsets.UTF_8));
    }
}

