/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.exception.Trap;
import org.refcodes.io.IOResultAccessor;
import org.refcodes.mixin.ResponseAccessor;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseEvent;
import org.refcodes.rest.RestfulClient;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.FormFields;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.MediaTypeFactoryLookup;
import org.refcodes.web.QueryFieldsAccessor;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestResponseResult
extends HttpClientRequest
implements RestResponseConsumer,
QueryFieldsAccessor.QueryFieldsProperty,
HeaderFieldsAccessor.HeaderFieldsProperty<RequestHeaderFields>,
RedirectDepthAccessor.RedirectDepthBuilder<RestResponseResult>,
HttpRequestBuilder<RestResponseResult>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestResponseResult>,
LinkComponent.LinkComponentBuilder<RestResponseResult>,
ConnectionStatusAccessor,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestResponseResult>,
IOResultAccessor<RestResponse, InterruptedException>,
ResponseAccessor<RestResponse> {
    private static final Logger LOGGER = Logger.getLogger(RestResponseResult.class.getName());
    private RestResponse _response = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, Object aRequest, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aRequest, aRedirectDepth, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, Object aRequest, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aRequest, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aHeaderFields, aRequest, aRedirectDepth, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aHeaderFields, aRequest, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, int aRedirectDepth, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aRedirectDepth, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(HttpMethod aHttpMethod, Url aUrl, MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(aHttpMethod, aUrl, aMediaTypeFactoryLookup);
    }

    public RestResponseResult(MediaTypeFactoryLookup aMediaTypeFactoryLookup) {
        super(null, null, null, null, aMediaTypeFactoryLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse getResult() throws InterruptedException {
        if (!this.hasResult()) {
            RestResponseResult restResponseResult = this;
            synchronized (restResponseResult) {
                block7: {
                    if (!this.hasResult()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            if (this.hasResult()) break block7;
                            throw e;
                        }
                    }
                }
            }
        }
        return this.getResponse();
    }

    public RestResponse getResponse() {
        return this._response;
    }

    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
        RestResponseResult restResponseResult = this;
        synchronized (restResponseResult) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
        RestResponseResult restResponseResult = this;
        synchronized (restResponseResult) {
            this.notifyAll();
        }
    }

    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    public void setHeaderFields(RequestHeaderFields aHeaderFields) {
        this._headerFields = aHeaderFields;
    }

    public Url getUrl() {
        return this._url;
    }

    public void setUrl(Url aUrl) {
        this._url = aUrl;
    }

    public boolean hasResult() {
        return this.getResponse() != null;
    }

    public void setQueryFields(FormFields aQueryFields) {
        Url theUrl = this.getUrl();
        UrlBuilder theUrlBuilder = theUrl instanceof UrlAccessor.UrlBuilder ? (UrlBuilder)theUrl : new UrlBuilder(theUrl);
        theUrlBuilder.setQueryFields(aQueryFields);
        this.setUrl((Url)theUrlBuilder);
    }

    public FormFields getQueryFields() {
        return this.getUrl().getQueryFields();
    }

    public RestResponseResult withUrl(Url aUrl) {
        this.setUrl(aUrl);
        return this;
    }

    public RestResponseResult withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public <REQ> RestResponseResult withRequest(REQ aRequest) {
        this.setRequest(aRequest);
        return this;
    }

    public RestResponseResult withHeaderFields(RequestHeaderFields aRequestHeaderFields) {
        this.setHeaderFields(aRequestHeaderFields);
        return this;
    }

    public RestResponseResult withRedirectDepth(int aRedirectDepth) {
        this.setRedirectDepth(aRedirectDepth);
        return this;
    }

    public RestResponseResult withOpen() throws IOException {
        this.open();
        return this;
    }

    public RestResponseResult withClose() throws IOException {
        this.close();
        return this;
    }

    public RestResponseResult withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    public RestResponseResult withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    public RestResponseResult build(RestfulClient aRestClient) {
        return new RestResponseResult((MediaTypeFactoryLookup)aRestClient);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this._httpMethod) + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements((Map)this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(RestResponseEvent aResponse) throws HttpResponseException {
        if (this.getConnectionStatus() != ConnectionStatus.CLOSED) {
            this._response = aResponse;
            RestResponseResult restResponseResult = this;
            synchronized (restResponseResult) {
                this.notifyAll();
            }
        } else {
            LOGGER.log(Level.WARNING, "Ignoring response <" + String.valueOf((Object)aResponse) + "> as this rest endpoint is in status <" + String.valueOf(this._connectionStatus) + ">, you may have closed it already?");
        }
    }

    static class RestResponseResultDaemon
    implements Runnable {
        private final RestResponseResult _responseResult;
        private final RestRequestHandler _requestHandler;
        private final RestfulClient _source;

        protected RestResponseResultDaemon(RestResponseResult aRestResponseResult, RestRequestHandler aRequestHandler, RestfulClient aSource) {
            if (aRequestHandler == null) {
                throw new IllegalArgumentException("Unable to process your request <" + aRestResponseResult.toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been implemented, aborting!");
            }
            this._responseResult = aRestResponseResult;
            this._requestHandler = aRequestHandler;
            this._source = aSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RestResponseResult restResponseResult = this._responseResult;
                synchronized (restResponseResult) {
                    while (this._responseResult.getConnectionStatus() == ConnectionStatus.NONE) {
                        try {
                            this._responseResult.wait(DaemonLoopSleepTime.MAX.getTimeMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this._responseResult.getConnectionStatus() != ConnectionStatus.NONE) continue;
                        LOGGER.log(Level.WARNING, "Your result's <" + String.valueOf(this._responseResult) + "> connection status is still <" + String.valueOf(this._responseResult.getConnectionStatus()) + "> after <" + DaemonLoopSleepTime.MAX.getTimeMillis() + "> ms, execution of your request starts not earlier than you calling the #open() method.");
                    }
                }
                if (this._responseResult.getConnectionStatus() != ConnectionStatus.OPENED) {
                    throw new IllegalStateException("Aborting your request as of your result <" + String.valueOf(this._responseResult) + "> connection status is <" + String.valueOf(this._responseResult.getConnectionStatus()) + "> although it is expected to e <" + String.valueOf(ConnectionStatus.OPENED) + ">.");
                }
                RestResponse theResponse = this._requestHandler.doRequest(this._responseResult);
                this._responseResult.onResponse(new RestResponseEvent(theResponse, this._source));
            }
            catch (HttpResponseException e) {
                LOGGER.log(Level.SEVERE, Trap.asMessage((Throwable)e), e);
            }
        }
    }
}

