/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

final class FluxBufferWhen<T, U, V, C extends Collection<? super T>>
extends FluxOperator<T, C> {
    final Publisher<U> start;
    final Function<? super U, ? extends Publisher<V>> end;
    final Supplier<C> bufferSupplier;
    final Supplier<? extends Queue<C>> queueSupplier;

    FluxBufferWhen(Flux<? extends T> source, Publisher<U> start, Function<? super U, ? extends Publisher<V>> end, Supplier<C> bufferSupplier, Supplier<? extends Queue<C>> queueSupplier) {
        super(source);
        this.start = Objects.requireNonNull(start, "start");
        this.end = Objects.requireNonNull(end, "end");
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void subscribe(CoreSubscriber<? super C> actual) {
        Queue<C> q = this.queueSupplier.get();
        BufferStartEndMainSubscriber parent = new BufferStartEndMainSubscriber(actual, this.bufferSupplier, q, this.end);
        actual.onSubscribe(parent);
        this.start.subscribe(parent.starter);
        this.source.subscribe(parent);
    }

    static final class BufferStartEndEnder<T, V, C extends Collection<? super T>>
    extends Operators.DeferredSubscription
    implements InnerConsumer<V> {
        final BufferStartEndMainSubscriber<T, ?, V, C> main;
        final C buffer;
        final long index;

        BufferStartEndEnder(BufferStartEndMainSubscriber<T, ?, V, C> main, C buffer, long index) {
            this.main = main;
            this.buffer = buffer;
            this.index = index;
        }

        @Override
        public Context currentContext() {
            return this.main.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(V t) {
            if (!this.isCancelled()) {
                this.cancel();
                this.main.endSignal(this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.main.endError(t);
        }

        @Override
        public void onComplete() {
            if (!this.isCancelled()) {
                this.main.endSignal(this);
            }
        }
    }

    static final class BufferStartEndStarter<U>
    extends Operators.DeferredSubscription
    implements InnerConsumer<U> {
        final BufferStartEndMainSubscriber<?, U, ?, ?> main;

        BufferStartEndStarter(BufferStartEndMainSubscriber<?, U, ?, ?> main) {
            this.main = main;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(U t) {
            this.main.startNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.main.startError(t);
        }

        @Override
        public void onComplete() {
            this.main.startComplete();
        }

        @Override
        public Context currentContext() {
            return this.main.currentContext();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.ACTUAL) {
                return this.main;
            }
            return super.scanUnsafe(key);
        }
    }

    static final class BufferStartEndMainSubscriber<T, U, V, C extends Collection<? super T>>
    implements InnerOperator<T, C> {
        final Supplier<C> bufferSupplier;
        final Queue<C> queue;
        final Function<? super U, ? extends Publisher<V>> end;
        final CoreSubscriber<? super C> actual;
        Set<Subscription> endSubscriptions;
        final BufferStartEndStarter<U> starter;
        Map<Long, C> buffers;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<BufferStartEndMainSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(BufferStartEndMainSubscriber.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferStartEndMainSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferStartEndMainSubscriber.class, "requested");
        long index;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BufferStartEndMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferStartEndMainSubscriber.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<BufferStartEndMainSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(BufferStartEndMainSubscriber.class, Throwable.class, "error");
        volatile boolean done;
        volatile boolean cancelled;
        volatile int open;
        static final AtomicIntegerFieldUpdater<BufferStartEndMainSubscriber> OPEN = AtomicIntegerFieldUpdater.newUpdater(BufferStartEndMainSubscriber.class, "open");

        BufferStartEndMainSubscriber(CoreSubscriber<? super C> actual, Supplier<C> bufferSupplier, Queue<C> queue, Function<? super U, ? extends Publisher<V>> end) {
            this.actual = actual;
            this.bufferSupplier = bufferSupplier;
            this.buffers = new HashMap<Long, C>();
            this.endSubscriptions = new HashSet<Subscription>();
            this.queue = queue;
            this.end = end;
            this.open = 1;
            this.starter = new BufferStartEndStarter(this);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public final CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferStartEndMainSubscriber bufferStartEndMainSubscriber = this;
            synchronized (bufferStartEndMainSubscriber) {
                Map<Long, C> set = this.buffers;
                if (set != null) {
                    for (Collection b : set.values()) {
                        b.add(t);
                    }
                    return;
                }
            }
            Operators.onNextDropped(t, this.actual.currentContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable t) {
            boolean report;
            BufferStartEndMainSubscriber bufferStartEndMainSubscriber = this;
            synchronized (bufferStartEndMainSubscriber) {
                Map<Long, C> set = this.buffers;
                if (set != null) {
                    this.buffers = null;
                    report = true;
                } else {
                    report = false;
                }
            }
            if (report) {
                this.anyError(t);
            } else {
                Operators.onErrorDropped(t, this.actual.currentContext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            Map<Long, C> set;
            BufferStartEndMainSubscriber bufferStartEndMainSubscriber = this;
            synchronized (bufferStartEndMainSubscriber) {
                set = this.buffers;
                if (set == null) {
                    return;
                }
            }
            this.cancelStart();
            this.cancelEnds();
            for (Collection b : set.values()) {
                this.queue.offer(b);
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
            }
        }

        void cancelMain() {
            Operators.terminate(S, this);
        }

        void cancelStart() {
            this.starter.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelEnds() {
            Set<Subscription> set;
            BufferStartEndStarter<U> bufferStartEndStarter = this.starter;
            synchronized (bufferStartEndStarter) {
                set = this.endSubscriptions;
                if (set == null) {
                    return;
                }
                this.endSubscriptions = null;
            }
            for (Subscription s : set) {
                s.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addEndSubscription(Subscription s) {
            BufferStartEndStarter<U> bufferStartEndStarter = this.starter;
            synchronized (bufferStartEndStarter) {
                Set<Subscription> set = this.endSubscriptions;
                if (set != null) {
                    set.add(s);
                    return true;
                }
            }
            s.cancel();
            return false;
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelMain();
                this.cancelStart();
                this.cancelEnds();
            }
        }

        boolean emit(C b) {
            long r = this.requested;
            if (r != 0L) {
                this.actual.onNext(b);
                if (r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return true;
            }
            this.actual.onError(Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            return false;
        }

        void anyError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t, this.actual.currentContext());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startNext(U u) {
            Publisher<V> p;
            Collection b;
            long idx = this.index;
            this.index = idx + 1L;
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
            }
            catch (Throwable e) {
                this.anyError(Operators.onOperatorError(this.starter, e, u, this.actual.currentContext()));
                return;
            }
            BufferStartEndMainSubscriber e = this;
            synchronized (e) {
                Map<Long, C> set = this.buffers;
                if (set == null) {
                    return;
                }
                set.put(idx, b);
            }
            try {
                p = Objects.requireNonNull(this.end.apply(u), "The end returned a null publisher");
            }
            catch (Throwable e2) {
                this.anyError(Operators.onOperatorError(this.starter, e2, u, this.actual.currentContext()));
                return;
            }
            BufferStartEndEnder end = new BufferStartEndEnder(this, b, idx);
            if (this.addEndSubscription(end)) {
                OPEN.getAndIncrement(this);
                p.subscribe(end);
            }
        }

        void startError(Throwable e) {
            this.anyError(e);
        }

        void startComplete() {
            if (OPEN.decrementAndGet(this) == 0) {
                this.cancelAll();
                this.done = true;
                this.drain();
            }
        }

        void cancelAll() {
            this.cancelMain();
            this.cancelStart();
            this.cancelEnds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endSignal(BufferStartEndEnder<T, V, C> ender) {
            BufferStartEndMainSubscriber bufferStartEndMainSubscriber = this;
            synchronized (bufferStartEndMainSubscriber) {
                Map<Long, C> set = this.buffers;
                if (set == null) {
                    return;
                }
                if (set.remove(ender.index) == null) {
                    return;
                }
                this.queue.offer(ender.buffer);
            }
            if (OPEN.decrementAndGet(this) == 0) {
                this.cancelAll();
                this.done = true;
            }
            this.drain();
        }

        void endError(Throwable e) {
            this.anyError(e);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            CoreSubscriber<? super C> a = this.actual;
            Queue<C> q = this.queue;
            int missed = 1;
            while (true) {
                boolean empty;
                boolean d = this.done;
                Collection b = (Collection)q.poll();
                boolean bl = empty = b == null;
                if (this.checkTerminated(d, empty, a, q)) {
                    return;
                }
                if (!empty) {
                    long r = this.requested;
                    if (r != 0L) {
                        this.actual.onNext(b);
                        if (r == Long.MAX_VALUE) continue;
                        REQUESTED.decrementAndGet(this);
                        continue;
                    }
                    this.anyError(Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                Throwable e = Exceptions.terminate(ERROR, this);
                if (e != null && e != Exceptions.TERMINATED) {
                    this.cancel();
                    this.queue.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.buffers.values().stream().mapToInt(Collection::size).sum();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            return InnerOperator.super.scanUnsafe(key);
        }
    }
}

