/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.redisson.RedissonLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLockAsync;
import org.redisson.api.RLockReactive;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonExpirableReactive;

public class RedissonLockReactive
extends RedissonExpirableReactive
implements RLockReactive {
    private final RLockAsync instance;

    public RedissonLockReactive(CommandReactiveExecutor connectionManager, String name) {
        super(connectionManager, name);
        this.instance = this.createLock(connectionManager, name);
    }

    protected RLockAsync createLock(CommandAsyncExecutor connectionManager, String name) {
        return new RedissonLock(this.commandExecutor, name);
    }

    @Override
    public Publisher<Boolean> forceUnlock() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.forceUnlockAsync();
            }
        });
    }

    @Override
    public Publisher<Void> unlock() {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.unlockAsync();
            }
        });
    }

    @Override
    public Publisher<Void> unlock(final long threadId) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.unlockAsync(threadId);
            }
        });
    }

    @Override
    public Publisher<Boolean> tryLock() {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.tryLockAsync();
            }
        });
    }

    @Override
    public Publisher<Void> lock() {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.lockAsync();
            }
        });
    }

    @Override
    public Publisher<Void> lock(final long threadId) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.lockAsync(threadId);
            }
        });
    }

    @Override
    public Publisher<Void> lock(final long leaseTime, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.lockAsync(leaseTime, unit);
            }
        });
    }

    @Override
    public Publisher<Void> lock(final long leaseTime, final TimeUnit unit, final long threadId) {
        return this.reactive(new Supplier<RFuture<Void>>(){

            @Override
            public RFuture<Void> get() {
                return RedissonLockReactive.this.instance.lockAsync(leaseTime, unit, threadId);
            }
        });
    }

    @Override
    public Publisher<Boolean> tryLock(final long threadId) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.tryLockAsync(threadId);
            }
        });
    }

    @Override
    public Publisher<Boolean> tryLock(final long waitTime, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.tryLockAsync(waitTime, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> tryLock(final long waitTime, final long leaseTime, final TimeUnit unit) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.tryLockAsync(waitTime, leaseTime, unit);
            }
        });
    }

    @Override
    public Publisher<Boolean> tryLock(final long waitTime, final long leaseTime, final TimeUnit unit, final long threadId) {
        return this.reactive(new Supplier<RFuture<Boolean>>(){

            @Override
            public RFuture<Boolean> get() {
                return RedissonLockReactive.this.instance.tryLockAsync(waitTime, leaseTime, unit, threadId);
            }
        });
    }
}

