/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.Set;
import org.redisson.RedissonSet;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.RCollectionAsync;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RSet;
import org.redisson.client.RedisClient;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.BaseTransactionalSet;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.set.AddOperation;
import org.redisson.transaction.operation.set.MoveOperation;
import org.redisson.transaction.operation.set.RemoveOperation;

public class TransactionalSet<V>
extends BaseTransactionalSet<V> {
    private final RSet<V> set;
    private final String transactionId;

    public TransactionalSet(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, RSet<V> set, String transactionId) {
        super(commandExecutor, timeout, operations, set);
        this.set = set;
        this.transactionId = transactionId;
    }

    @Override
    protected ScanResult<Object> scanIteratorSource(String name, RedisClient client, long startPos, String pattern, int count) {
        return ((ScanIterator)((Object)this.set)).scanIterator(name, client, startPos, pattern, count);
    }

    @Override
    protected RFuture<Set<V>> readAllAsyncSource() {
        return this.set.readAllAsync();
    }

    @Override
    protected TransactionalOperation createAddOperation(V value, long threadId) {
        return new AddOperation(this.set, value, this.transactionId, threadId);
    }

    @Override
    protected MoveOperation createMoveOperation(String destination, V value, long threadId) {
        return new MoveOperation(this.set, destination, threadId, value, this.transactionId);
    }

    @Override
    protected TransactionalOperation createRemoveOperation(Object value, long threadId) {
        return new RemoveOperation(this.set, value, this.transactionId, threadId);
    }

    @Override
    protected RLock getLock(RCollectionAsync<V> set, V value) {
        String lockName = ((RedissonSet)set).getLockByValue(value, "lock");
        return new RedissonTransactionalLock(this.commandExecutor, lockName, this.transactionId);
    }
}

