/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.redisson.api.RFuture;

public abstract class PublisherAdder<V> {
    public abstract RFuture<Boolean> add(Object var1);

    public Single<Boolean> addAll(Publisher<? extends V> c) {
        final Flowable<? extends V> cc = Flowable.fromPublisher(c);
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long t) throws Exception {
                final AtomicBoolean completed = new AtomicBoolean();
                final AtomicLong values = new AtomicLong();
                final AtomicBoolean lastSize = new AtomicBoolean();
                cc.subscribe(new Consumer<V>(){

                    @Override
                    public void accept(V t) throws Exception {
                        values.getAndIncrement();
                        PublisherAdder.this.add(t).onComplete((res, e) -> {
                            if (e != null) {
                                p.onError((Throwable)e);
                                return;
                            }
                            if (res.booleanValue()) {
                                lastSize.set(true);
                            }
                            if (values.decrementAndGet() == 0L && completed.get()) {
                                p.onNext(lastSize.get());
                                p.onComplete();
                            }
                        });
                    }
                }, (Consumer<Throwable>)new Consumer<Throwable>(){

                    @Override
                    public void accept(Throwable t) throws Exception {
                        p.onError(t);
                    }
                }, new Action(){

                    @Override
                    public void run() throws Exception {
                        completed.set(true);
                        if (values.get() == 0L) {
                            p.onNext(lastSize.get());
                            p.onComplete();
                        }
                    }
                });
            }
        }).singleOrError();
    }
}

