/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.redisnode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.api.redisnode.BaseRedisNodes;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;
import org.redisson.redisnode.RedisNode;

public class RedissonBaseNodes
implements BaseRedisNodes {
    ConnectionManager connectionManager;
    CommandAsyncExecutor commandExecutor;

    public RedissonBaseNodes(ConnectionManager connectionManager, CommandAsyncExecutor commandExecutor) {
        this.connectionManager = connectionManager;
        this.commandExecutor = commandExecutor;
    }

    protected <T extends org.redisson.api.redisnode.RedisNode> Collection<T> getNodes(NodeType type) {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        ArrayList<RedisNode> result = new ArrayList<RedisNode>();
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (masterSlaveEntry.getAllEntries().isEmpty() && type == NodeType.MASTER) {
                RedisNode entry = new RedisNode(masterSlaveEntry.getClient(), this.commandExecutor, NodeType.MASTER);
                result.add(entry);
            }
            for (ClientConnectionsEntry slaveEntry : masterSlaveEntry.getAllEntries()) {
                if (slaveEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER || slaveEntry.getNodeType() != type) continue;
                RedisNode entry = new RedisNode(slaveEntry.getClient(), this.commandExecutor, slaveEntry.getNodeType());
                result.add(entry);
            }
        }
        return result;
    }

    protected RedisNode getNode(String address, NodeType nodeType) {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        RedisURI addr = new RedisURI(address);
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (nodeType == NodeType.MASTER && masterSlaveEntry.getAllEntries().isEmpty() && RedisURI.compare(masterSlaveEntry.getClient().getAddr(), addr)) {
                return new RedisNode(masterSlaveEntry.getClient(), this.commandExecutor, NodeType.MASTER);
            }
            for (ClientConnectionsEntry entry : masterSlaveEntry.getAllEntries()) {
                if (!RedisURI.compare(entry.getClient().getAddr(), addr) || entry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER) continue;
                return new RedisNode(entry.getClient(), this.commandExecutor, entry.getNodeType());
            }
        }
        return null;
    }

    protected List<RedisNode> getNodes() {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        ArrayList<RedisNode> result = new ArrayList<RedisNode>();
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (masterSlaveEntry.getAllEntries().isEmpty()) {
                RedisNode masterEntry = new RedisNode(masterSlaveEntry.getClient(), this.commandExecutor, NodeType.MASTER);
                result.add(masterEntry);
            }
            for (ClientConnectionsEntry slaveEntry : masterSlaveEntry.getAllEntries()) {
                if (slaveEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER) continue;
                RedisNode entry = new RedisNode(slaveEntry.getClient(), this.commandExecutor, slaveEntry.getNodeType());
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public boolean pingAll(long timeout, TimeUnit timeUnit) {
        List<RedisNode> clients = this.getNodes();
        ConcurrentHashMap result = new ConcurrentHashMap(clients.size());
        CountDownLatch latch = new CountDownLatch(clients.size());
        for (RedisNode entry : clients) {
            RFuture<RedisConnection> f = entry.getClient().connectAsync();
            f.onComplete((c, e) -> {
                if (c != null) {
                    RFuture r = c.async(timeUnit.toMillis(timeout), RedisCommands.PING, new Object[0]);
                    result.put(c, r);
                    latch.countDown();
                } else {
                    latch.countDown();
                }
            });
        }
        long time = System.currentTimeMillis();
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        if (System.currentTimeMillis() - time >= (long)this.connectionManager.getConfig().getConnectTimeout()) {
            for (Map.Entry entry : result.entrySet()) {
                ((RedisConnection)entry.getKey()).closeAsync();
            }
            return false;
        }
        time = System.currentTimeMillis();
        boolean res = true;
        for (Map.Entry entry : result.entrySet()) {
            RFuture f = (RFuture)entry.getValue();
            f.awaitUninterruptibly();
            if (!"PONG".equals(f.getNow())) {
                res = false;
            }
            ((RedisConnection)entry.getKey()).closeAsync();
        }
        return res && result.size() == clients.size();
    }

    @Override
    public boolean pingAll() {
        return this.pingAll(1L, TimeUnit.SECONDS);
    }
}

