/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AsyncSemaphore {
    private final AtomicInteger counter;
    private final Queue<Runnable> listeners = new ConcurrentLinkedQueue<Runnable>();

    public AsyncSemaphore(int permits) {
        this.counter = new AtomicInteger(permits);
    }

    public boolean tryAcquire(long timeoutMillis) {
        CountDownLatch latch = new CountDownLatch(1);
        Runnable runnable = () -> latch.countDown();
        this.acquire(runnable);
        try {
            return latch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public int queueSize() {
        return this.listeners.size();
    }

    public void removeListeners() {
        this.listeners.clear();
    }

    public void acquire(Runnable listener) {
        this.listeners.add(listener);
        this.tryRun();
    }

    private void tryRun() {
        if (this.counter.decrementAndGet() >= 0) {
            Runnable listener = this.listeners.poll();
            if (listener == null) {
                this.counter.incrementAndGet();
                return;
            }
            listener.run();
        } else if (this.counter.incrementAndGet() > 0) {
            this.tryRun();
        }
    }

    public int getCounter() {
        return this.counter.get();
    }

    public void release() {
        this.counter.incrementAndGet();
        this.tryRun();
    }

    public String toString() {
        return "value:" + this.counter + ":queue:" + this.queueSize();
    }
}

