/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.redisson.cache.CachedValue;
import org.redisson.cache.CachedValueSoftReference;
import org.redisson.cache.CachedValueWeakReference;
import org.redisson.cache.StdCachedValue;

public class ReferenceCachedValue<K, V>
extends StdCachedValue<K, V>
implements CachedValue<K, V> {
    private final Reference<V> ref;

    public ReferenceCachedValue(K key, V value, long ttl, long maxIdleTime, ReferenceQueue<V> queue, Type type) {
        super(key, null, ttl, maxIdleTime);
        this.ref = type == Type.SOFT ? new CachedValueSoftReference<V>(this, value, queue) : new CachedValueWeakReference<V>(this, value, queue);
    }

    @Override
    public V getValue() {
        super.getValue();
        return this.ref.get();
    }

    public static enum Type {
        SOFT,
        WEAK;

    }
}

