/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.redisson.RedissonBaseLock;
import org.redisson.api.LockOptions;
import org.redisson.api.RFuture;
import org.redisson.client.RedisException;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;

public class RedissonSpinLock
extends RedissonBaseLock {
    protected long internalLockLeaseTime;
    protected final LockOptions.BackOff backOff;
    final CommandAsyncExecutor commandExecutor;

    public RedissonSpinLock(CommandAsyncExecutor commandExecutor, String name, LockOptions.BackOff backOff) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.internalLockLeaseTime = commandExecutor.getConnectionManager().getCfg().getLockWatchdogTimeout();
        this.backOff = backOff;
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly(-1L, null);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lock(long leaseTime, TimeUnit unit) {
        try {
            this.lockInterruptibly(leaseTime, unit);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lockInterruptibly(-1L, null);
    }

    @Override
    public void lockInterruptibly(long leaseTime, TimeUnit unit) throws InterruptedException {
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return;
        }
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        while (ttl != null) {
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            Thread.sleep(nextSleepPeriod);
            ttl = this.tryAcquire(leaseTime, unit, threadId);
        }
    }

    private Long tryAcquire(long leaseTime, TimeUnit unit, long threadId) {
        return this.get(this.tryAcquireAsync(leaseTime, unit, threadId));
    }

    private <T> RFuture<Long> tryAcquireAsync(long leaseTime, TimeUnit unit, long threadId) {
        if (leaseTime != -1L) {
            return this.tryLockInnerAsync(leaseTime, unit, threadId, RedisCommands.EVAL_LONG);
        }
        RFuture<Long> ttlRemainingFuture = this.tryLockInnerAsync(this.internalLockLeaseTime, TimeUnit.MILLISECONDS, threadId, RedisCommands.EVAL_LONG);
        ttlRemainingFuture.onComplete((ttlRemaining, e) -> {
            if (e != null) {
                return;
            }
            if (ttlRemaining == null) {
                this.scheduleExpirationRenewal(threadId);
            }
        });
        return ttlRemainingFuture;
    }

    @Override
    public boolean tryLock() {
        return this.get(this.tryLockAsync());
    }

    <T> RFuture<T> tryLockInnerAsync(long leaseTime, TimeUnit unit, long threadId, RedisStrictCommand<T> command) {
        this.internalLockLeaseTime = unit.toMillis(leaseTime);
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, command, "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; if (redis.call('hexists', KEYS[1], ARGV[2]) == 1) then redis.call('hincrby', KEYS[1], ARGV[2], 1); redis.call('pexpire', KEYS[1], ARGV[1]); return nil; end; return redis.call('pttl', KEYS[1]);", Collections.singletonList(this.getRawName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public boolean tryLock(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        Long ttl = this.tryAcquire(leaseTime, unit, threadId);
        if (ttl == null) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        while (ttl != null) {
            current = System.currentTimeMillis();
            Thread.sleep(backOffPolicy.getNextSleepPeriod());
            ttl = this.tryAcquire(leaseTime, unit, threadId);
            if ((time -= System.currentTimeMillis() - current) > 0L) continue;
            this.acquireFailed(waitTime, unit, threadId);
            return false;
        }
        return true;
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) throws InterruptedException {
        return this.tryLock(waitTime, -1L, unit);
    }

    @Override
    public void unlock() {
        try {
            this.get(this.unlockAsync(Thread.currentThread().getId()));
        }
        catch (RedisException e) {
            if (e.getCause() instanceof IllegalMonitorStateException) {
                throw (IllegalMonitorStateException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public boolean forceUnlock() {
        return this.get(this.forceUnlockAsync());
    }

    @Override
    public RFuture<Boolean> forceUnlockAsync() {
        this.cancelExpirationRenewal(null);
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('del', KEYS[1]) == 1) then return 1 else return 0 end", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    protected RFuture<Boolean> unlockInnerAsync(long threadId) {
        return this.evalWriteAsync(this.getRawName(), LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if (redis.call('hexists', KEYS[1], ARGV[2]) == 0) then return nil;end; local counter = redis.call('hincrby', KEYS[1], ARGV[2], -1); if (counter > 0) then redis.call('pexpire', KEYS[1], ARGV[1]); return 0; else redis.call('del', KEYS[1]); return 1; end; return nil;", Collections.singletonList(this.getRawName()), this.internalLockLeaseTime, this.getLockName(threadId));
    }

    @Override
    public RFuture<Void> lockAsync() {
        return this.lockAsync(-1L, null);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.lockAsync(leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long currentThreadId) {
        return this.lockAsync(-1L, null, currentThreadId);
    }

    @Override
    public RFuture<Void> lockAsync(long leaseTime, TimeUnit unit, long currentThreadId) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        this.lockAsync(leaseTime, unit, currentThreadId, result, backOffPolicy);
        return result;
    }

    private void lockAsync(long leaseTime, TimeUnit unit, long currentThreadId, RPromise<Void> result, LockOptions.BackOffPolicy backOffPolicy) {
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(null)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            this.commandExecutor.getConnectionManager().newTimeout(timeout -> this.lockAsync(leaseTime, unit, currentThreadId, result, backOffPolicy), nextSleepPeriod, TimeUnit.MILLISECONDS);
        });
    }

    @Override
    public RFuture<Boolean> tryLockAsync() {
        return this.tryLockAsync(Thread.currentThread().getId());
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long threadId) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        RFuture<Long> longRFuture = this.tryAcquireAsync(-1L, null, threadId);
        longRFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
            }
            result.trySuccess(res == null);
        });
        return result;
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, TimeUnit unit) {
        return this.tryLockAsync(waitTime, -1L, unit);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.tryLockAsync(waitTime, leaseTime, unit, currentThreadId);
    }

    @Override
    public RFuture<Boolean> tryLockAsync(long waitTime, long leaseTime, TimeUnit unit, long currentThreadId) {
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        LockOptions.BackOffPolicy backOffPolicy = this.backOff.create();
        this.tryLock(leaseTime, unit, currentThreadId, result, time, backOffPolicy);
        return result;
    }

    private void tryLock(long leaseTime, TimeUnit unit, long currentThreadId, RPromise<Boolean> result, AtomicLong time, LockOptions.BackOffPolicy backOffPolicy) {
        long startTime = System.currentTimeMillis();
        RFuture<Long> ttlFuture = this.tryAcquireAsync(leaseTime, unit, currentThreadId);
        ttlFuture.onComplete((ttl, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (ttl == null) {
                if (!result.trySuccess(true)) {
                    this.unlockAsync(currentThreadId);
                }
                return;
            }
            long el = System.currentTimeMillis() - startTime;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.trySuccessFalse(currentThreadId, result);
                return;
            }
            long nextSleepPeriod = backOffPolicy.getNextSleepPeriod();
            this.commandExecutor.getConnectionManager().newTimeout(timeout -> this.tryLock(leaseTime, unit, currentThreadId, result, time, backOffPolicy), nextSleepPeriod, TimeUnit.MILLISECONDS);
        });
    }

    private void trySuccessFalse(long currentThreadId, RPromise<Boolean> result) {
        this.acquireFailedAsync(-1L, null, currentThreadId).onComplete((res, e) -> {
            if (e == null) {
                result.trySuccess(false);
            } else {
                result.tryFailure((Throwable)e);
            }
        });
    }
}

