/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.QueueTransferService;
import org.redisson.RedisClusterNodes;
import org.redisson.RedisNodes;
import org.redisson.RedissonAtomicDouble;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonBatch;
import org.redisson.RedissonBinaryStream;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBloomFilter;
import org.redisson.RedissonBoundedBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonDelayedQueue;
import org.redisson.RedissonDeque;
import org.redisson.RedissonDoubleAdder;
import org.redisson.RedissonExecutorService;
import org.redisson.RedissonFairLock;
import org.redisson.RedissonGeo;
import org.redisson.RedissonHyperLogLog;
import org.redisson.RedissonIdGenerator;
import org.redisson.RedissonKeys;
import org.redisson.RedissonLexSortedSet;
import org.redisson.RedissonList;
import org.redisson.RedissonListMultimap;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonLocalCachedMap;
import org.redisson.RedissonLock;
import org.redisson.RedissonLongAdder;
import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.RedissonMultiLock;
import org.redisson.RedissonObject;
import org.redisson.RedissonPatternTopic;
import org.redisson.RedissonPermitExpirableSemaphore;
import org.redisson.RedissonPriorityBlockingDeque;
import org.redisson.RedissonPriorityBlockingQueue;
import org.redisson.RedissonPriorityDeque;
import org.redisson.RedissonPriorityQueue;
import org.redisson.RedissonQueue;
import org.redisson.RedissonRateLimiter;
import org.redisson.RedissonReactive;
import org.redisson.RedissonReadWriteLock;
import org.redisson.RedissonRedLock;
import org.redisson.RedissonReference;
import org.redisson.RedissonReliableTopic;
import org.redisson.RedissonRemoteService;
import org.redisson.RedissonRingBuffer;
import org.redisson.RedissonRx;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonScript;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetCache;
import org.redisson.RedissonSetMultimap;
import org.redisson.RedissonSetMultimapCache;
import org.redisson.RedissonSortedSet;
import org.redisson.RedissonSpinLock;
import org.redisson.RedissonStream;
import org.redisson.RedissonTimeSeries;
import org.redisson.RedissonTopic;
import org.redisson.RedissonTransferQueue;
import org.redisson.WriteBehindService;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNodesGroup;
import org.redisson.api.ExecutorOptions;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.LockOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RBitSet;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RDeque;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RGeo;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RIdGenerator;
import org.redisson.api.RKeys;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RListMultimapCache;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RLock;
import org.redisson.api.RLongAdder;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RPriorityBlockingDeque;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RPriorityDeque;
import org.redisson.api.RPriorityQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RReliableTopic;
import org.redisson.api.RRemoteService;
import org.redisson.api.RRingBuffer;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScript;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RSetMultimapCache;
import org.redisson.api.RSortedSet;
import org.redisson.api.RStream;
import org.redisson.api.RTimeSeries;
import org.redisson.api.RTopic;
import org.redisson.api.RTransaction;
import org.redisson.api.RTransferQueue;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.TransactionOptions;
import org.redisson.api.redisnode.BaseRedisNodes;
import org.redisson.api.redisnode.RedisCluster;
import org.redisson.api.redisnode.RedisMasterSlave;
import org.redisson.api.redisnode.RedisSentinelMasterSlave;
import org.redisson.api.redisnode.RedisSingle;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandSyncService;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;
import org.redisson.connection.ConnectionManager;
import org.redisson.eviction.EvictionScheduler;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.redisnode.RedissonClusterNodes;
import org.redisson.redisnode.RedissonMasterSlaveNodes;
import org.redisson.redisnode.RedissonSentinelMasterSlaveNodes;
import org.redisson.redisnode.RedissonSingleNode;
import org.redisson.remote.ResponseEntry;
import org.redisson.transaction.RedissonTransaction;

public class Redisson
implements RedissonClient {
    protected final QueueTransferService queueTransferService = new QueueTransferService();
    protected final EvictionScheduler evictionScheduler;
    protected final WriteBehindService writeBehindService;
    protected final ConnectionManager connectionManager;
    protected final CommandAsyncExecutor commandExecutor;
    protected final ConcurrentMap<Class<?>, Class<?>> liveObjectClassCache = new ConcurrentHashMap();
    protected final Config config;
    protected final ConcurrentMap<String, ResponseEntry> responses = new ConcurrentHashMap<String, ResponseEntry>();

    protected Redisson(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        this.connectionManager = ConfigSupport.createConnectionManager(configCopy);
        RedissonObjectBuilder objectBuilder = null;
        if (config.isReferenceEnabled()) {
            objectBuilder = new RedissonObjectBuilder(this);
        }
        this.commandExecutor = new CommandSyncService(this.connectionManager, objectBuilder);
        this.evictionScheduler = new EvictionScheduler(this.commandExecutor);
        this.writeBehindService = new WriteBehindService(this.commandExecutor);
    }

    public EvictionScheduler getEvictionScheduler() {
        return this.evictionScheduler;
    }

    public CommandAsyncExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static RedissonClient create() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379");
        return Redisson.create(config);
    }

    public static RedissonClient create(Config config) {
        return new Redisson(config);
    }

    @Deprecated
    public static RedissonRxClient createRx() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379");
        return Redisson.createRx(config);
    }

    @Deprecated
    public static RedissonRxClient createRx(Config config) {
        return new RedissonRx(config);
    }

    @Override
    public RedissonRxClient rxJava() {
        return new RedissonRx(this.connectionManager, this.evictionScheduler, this.writeBehindService, this.responses);
    }

    @Deprecated
    public static RedissonReactiveClient createReactive() {
        Config config = new Config();
        config.useSingleServer().setAddress("redis://127.0.0.1:6379");
        return Redisson.createReactive(config);
    }

    @Deprecated
    public static RedissonReactiveClient createReactive(Config config) {
        return new RedissonReactive(config);
    }

    @Override
    public RedissonReactiveClient reactive() {
        return new RedissonReactive(this.connectionManager, this.evictionScheduler, this.writeBehindService, this.responses);
    }

    @Override
    public <V> RTimeSeries<V> getTimeSeries(String name) {
        return new RedissonTimeSeries(this.evictionScheduler, this.commandExecutor, name);
    }

    @Override
    public <V> RTimeSeries<V> getTimeSeries(String name, Codec codec) {
        return new RedissonTimeSeries(codec, this.evictionScheduler, this.commandExecutor, name);
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name) {
        return new RedissonStream(this.commandExecutor, name);
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name, Codec codec) {
        return new RedissonStream(codec, this.commandExecutor, name);
    }

    @Override
    public RBinaryStream getBinaryStream(String name) {
        return new RedissonBinaryStream(this.commandExecutor, name);
    }

    @Override
    public <V> RGeo<V> getGeo(String name) {
        return new RedissonGeo(this.commandExecutor, name, this);
    }

    @Override
    public <V> RGeo<V> getGeo(String name, Codec codec) {
        return new RedissonGeo(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        return new RedissonBucket(this.commandExecutor, name);
    }

    @Override
    public RRateLimiter getRateLimiter(String name) {
        return new RedissonRateLimiter(this.commandExecutor, name);
    }

    @Override
    public <V> RBucket<V> getBucket(String name, Codec codec) {
        return new RedissonBucket(codec, this.commandExecutor, name);
    }

    @Override
    public RBuckets getBuckets() {
        return new RedissonBuckets(this.commandExecutor);
    }

    @Override
    public RBuckets getBuckets(Codec codec) {
        return new RedissonBuckets(codec, this.commandExecutor);
    }

    @Override
    public <V> RHyperLogLog<V> getHyperLogLog(String name) {
        return new RedissonHyperLogLog(this.commandExecutor, name);
    }

    @Override
    public <V> RHyperLogLog<V> getHyperLogLog(String name, Codec codec) {
        return new RedissonHyperLogLog(codec, this.commandExecutor, name);
    }

    @Override
    public <V> RList<V> getList(String name) {
        return new RedissonList(this.commandExecutor, name, this);
    }

    @Override
    public <V> RList<V> getList(String name, Codec codec) {
        return new RedissonList(codec, this.commandExecutor, name, this);
    }

    @Override
    public <K, V> RListMultimap<K, V> getListMultimap(String name) {
        return new RedissonListMultimap(this.commandExecutor, name);
    }

    @Override
    public <K, V> RListMultimap<K, V> getListMultimap(String name, Codec codec) {
        return new RedissonListMultimap(codec, this.commandExecutor, name);
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, LocalCachedMapOptions<K, V> options) {
        return new RedissonLocalCachedMap<K, V>(this.commandExecutor, name, options, this.evictionScheduler, this, this.writeBehindService);
    }

    @Override
    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, Codec codec, LocalCachedMapOptions<K, V> options) {
        return new RedissonLocalCachedMap<K, V>(codec, this.commandExecutor, name, options, this.evictionScheduler, this, this.writeBehindService);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        return new RedissonMap(this.commandExecutor, name, this, null, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, MapOptions<K, V> options) {
        return new RedissonMap<K, V>(this.commandExecutor, name, this, options, this.writeBehindService);
    }

    @Override
    public <K, V> RSetMultimap<K, V> getSetMultimap(String name) {
        return new RedissonSetMultimap(this.commandExecutor, name);
    }

    @Override
    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name) {
        return new RedissonSetMultimapCache(this.evictionScheduler, this.commandExecutor, name);
    }

    @Override
    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name, Codec codec) {
        return new RedissonSetMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
    }

    @Override
    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name) {
        return new RedissonListMultimapCache(this.evictionScheduler, this.commandExecutor, name);
    }

    @Override
    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name, Codec codec) {
        return new RedissonListMultimapCache(this.evictionScheduler, codec, this.commandExecutor, name);
    }

    @Override
    public <K, V> RSetMultimap<K, V> getSetMultimap(String name, Codec codec) {
        return new RedissonSetMultimap(codec, this.commandExecutor, name);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name) {
        return new RedissonSetCache(this.evictionScheduler, this.commandExecutor, name, this);
    }

    @Override
    public <V> RSetCache<V> getSetCache(String name, Codec codec) {
        return new RedissonSetCache(codec, this.evictionScheduler, this.commandExecutor, name, this);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name) {
        return new RedissonMapCache(this.evictionScheduler, this.commandExecutor, name, (RedissonClient)this, null, null);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, MapOptions<K, V> options) {
        return new RedissonMapCache<K, V>(this.evictionScheduler, this.commandExecutor, name, (RedissonClient)this, options, this.writeBehindService);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec) {
        return new RedissonMapCache(codec, this.evictionScheduler, this.commandExecutor, name, this, null, null);
    }

    @Override
    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        return new RedissonMapCache<K, V>(codec, this.evictionScheduler, this.commandExecutor, name, this, options, this.writeBehindService);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        return new RedissonMap(codec, this.commandExecutor, name, this, null, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        return new RedissonMap<K, V>(codec, this.commandExecutor, name, this, options, this.writeBehindService);
    }

    @Override
    public RLock getLock(String name) {
        return new RedissonLock(this.commandExecutor, name);
    }

    @Override
    public RLock getSpinLock(String name) {
        return this.getSpinLock(name, LockOptions.defaults());
    }

    @Override
    public RLock getSpinLock(String name, LockOptions.BackOff backOff) {
        return new RedissonSpinLock(this.commandExecutor, name, backOff);
    }

    @Override
    public RLock getMultiLock(RLock ... locks) {
        return new RedissonMultiLock(locks);
    }

    @Override
    public RLock getRedLock(RLock ... locks) {
        return new RedissonRedLock(locks);
    }

    @Override
    public RLock getFairLock(String name) {
        return new RedissonFairLock(this.commandExecutor, name);
    }

    @Override
    public RReadWriteLock getReadWriteLock(String name) {
        return new RedissonReadWriteLock(this.commandExecutor, name);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        return new RedissonSet(this.commandExecutor, name, this);
    }

    @Override
    public <V> RSet<V> getSet(String name, Codec codec) {
        return new RedissonSet(codec, this.commandExecutor, name, this);
    }

    @Override
    public RScript getScript() {
        return new RedissonScript(this.commandExecutor);
    }

    @Override
    public RScript getScript(Codec codec) {
        return new RedissonScript(this.commandExecutor, codec);
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name) {
        return this.getExecutorService(name, this.connectionManager.getCodec());
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, ExecutorOptions options) {
        return this.getExecutorService(name, this.connectionManager.getCodec(), options);
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, Codec codec) {
        return this.getExecutorService(name, codec, ExecutorOptions.defaults());
    }

    @Override
    public RScheduledExecutorService getExecutorService(String name, Codec codec, ExecutorOptions options) {
        return new RedissonExecutorService(codec, this.commandExecutor, this, name, this.queueTransferService, this.responses, options);
    }

    @Override
    public RRemoteService getRemoteService() {
        return this.getRemoteService("redisson_rs", this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(String name) {
        return this.getRemoteService(name, this.connectionManager.getCodec());
    }

    @Override
    public RRemoteService getRemoteService(Codec codec) {
        return this.getRemoteService("redisson_rs", codec);
    }

    @Override
    public RRemoteService getRemoteService(String name, Codec codec) {
        String executorId = this.connectionManager.getId();
        if (codec != this.connectionManager.getCodec()) {
            executorId = executorId + ":" + name;
        }
        return new RedissonRemoteService(codec, name, this.commandExecutor, executorId, this.responses);
    }

    @Override
    public <V> RSortedSet<V> getSortedSet(String name) {
        return new RedissonSortedSet(this.commandExecutor, name, this);
    }

    @Override
    public <V> RSortedSet<V> getSortedSet(String name, Codec codec) {
        return new RedissonSortedSet(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name) {
        return new RedissonScoredSortedSet(this.commandExecutor, name, this);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name, Codec codec) {
        return new RedissonScoredSortedSet(codec, this.commandExecutor, name, this);
    }

    @Override
    public RLexSortedSet getLexSortedSet(String name) {
        return new RedissonLexSortedSet(this.commandExecutor, name, this);
    }

    @Override
    public RTopic getTopic(String name) {
        return new RedissonTopic(this.commandExecutor, name);
    }

    @Override
    public RTopic getTopic(String name, Codec codec) {
        return new RedissonTopic(codec, this.commandExecutor, name);
    }

    @Override
    public RReliableTopic getReliableTopic(String name) {
        return new RedissonReliableTopic(this.commandExecutor, name);
    }

    @Override
    public RReliableTopic getReliableTopic(String name, Codec codec) {
        return new RedissonReliableTopic(codec, this.commandExecutor, name);
    }

    @Override
    public RPatternTopic getPatternTopic(String pattern) {
        return new RedissonPatternTopic(this.commandExecutor, pattern);
    }

    @Override
    public RPatternTopic getPatternTopic(String pattern, Codec codec) {
        return new RedissonPatternTopic(codec, this.commandExecutor, pattern);
    }

    @Override
    public <V> RDelayedQueue<V> getDelayedQueue(RQueue<V> destinationQueue) {
        if (destinationQueue == null) {
            throw new NullPointerException();
        }
        return new RedissonDelayedQueue(this.queueTransferService, destinationQueue.getCodec(), this.commandExecutor, destinationQueue.getName());
    }

    @Override
    public <V> RQueue<V> getQueue(String name) {
        return new RedissonQueue(this.commandExecutor, name, this);
    }

    @Override
    public <V> RQueue<V> getQueue(String name, Codec codec) {
        return new RedissonQueue(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RTransferQueue<V> getTransferQueue(String name) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        return new RedissonTransferQueue(this.commandExecutor, name, service);
    }

    @Override
    public <V> RTransferQueue<V> getTransferQueue(String name, Codec codec) {
        String remoteName = RedissonObject.suffixName(name, "remoteService");
        RRemoteService service = this.getRemoteService(remoteName);
        return new RedissonTransferQueue(codec, this.commandExecutor, name, service);
    }

    @Override
    public <V> RRingBuffer<V> getRingBuffer(String name) {
        return new RedissonRingBuffer(this.commandExecutor, name, this);
    }

    @Override
    public <V> RRingBuffer<V> getRingBuffer(String name, Codec codec) {
        return new RedissonRingBuffer(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name) {
        return new RedissonBlockingQueue(this.commandExecutor, name, this);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new RedissonBlockingQueue(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name) {
        return new RedissonBoundedBlockingQueue(this.commandExecutor, name, this);
    }

    @Override
    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name, Codec codec) {
        return new RedissonBoundedBlockingQueue(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RDeque<V> getDeque(String name) {
        return new RedissonDeque(this.commandExecutor, name, this);
    }

    @Override
    public <V> RDeque<V> getDeque(String name, Codec codec) {
        return new RedissonDeque(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name) {
        return new RedissonBlockingDeque(this.commandExecutor, name, this);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name, Codec codec) {
        return new RedissonBlockingDeque(codec, this.commandExecutor, name, this);
    }

    @Override
    public RAtomicLong getAtomicLong(String name) {
        return new RedissonAtomicLong(this.commandExecutor, name);
    }

    @Override
    public RLongAdder getLongAdder(String name) {
        return new RedissonLongAdder(this.commandExecutor, name, this);
    }

    @Override
    public RDoubleAdder getDoubleAdder(String name) {
        return new RedissonDoubleAdder(this.commandExecutor, name, this);
    }

    @Override
    public RAtomicDouble getAtomicDouble(String name) {
        return new RedissonAtomicDouble(this.commandExecutor, name);
    }

    @Override
    public RCountDownLatch getCountDownLatch(String name) {
        return new RedissonCountDownLatch(this.commandExecutor, name);
    }

    @Override
    public RBitSet getBitSet(String name) {
        return new RedissonBitSet(this.commandExecutor, name);
    }

    @Override
    public RSemaphore getSemaphore(String name) {
        return new RedissonSemaphore(this.commandExecutor, name);
    }

    @Override
    public RPermitExpirableSemaphore getPermitExpirableSemaphore(String name) {
        return new RedissonPermitExpirableSemaphore(this.commandExecutor, name);
    }

    @Override
    public <V> RBloomFilter<V> getBloomFilter(String name) {
        return new RedissonBloomFilter(this.commandExecutor, name);
    }

    @Override
    public <V> RBloomFilter<V> getBloomFilter(String name, Codec codec) {
        return new RedissonBloomFilter(codec, this.commandExecutor, name);
    }

    @Override
    public RIdGenerator getIdGenerator(String name) {
        return new RedissonIdGenerator(this.commandExecutor, name);
    }

    @Override
    public RKeys getKeys() {
        return new RedissonKeys(this.commandExecutor);
    }

    @Override
    public RTransaction createTransaction(TransactionOptions options) {
        return new RedissonTransaction(this.commandExecutor, options);
    }

    @Override
    public RBatch createBatch(BatchOptions options) {
        return new RedissonBatch(this.evictionScheduler, this.commandExecutor, options);
    }

    @Override
    public RBatch createBatch() {
        return this.createBatch(BatchOptions.defaults());
    }

    @Override
    public RLiveObjectService getLiveObjectService() {
        return new RedissonLiveObjectService(this.liveObjectClassCache, this.commandExecutor);
    }

    @Override
    public void shutdown() {
        this.writeBehindService.stop();
        this.connectionManager.shutdown();
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        this.writeBehindService.stop();
        this.connectionManager.shutdown(quietPeriod, timeout, unit);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public <T extends BaseRedisNodes> T getRedisNodes(org.redisson.api.redisnode.RedisNodes<T> nodes) {
        if (nodes.getClazz() == RedisSingle.class) {
            if (this.config.isSentinelConfig() || this.config.isClusterConfig()) {
                throw new IllegalArgumentException("Can't be used in non Redis single configuration");
            }
            return (T)new RedissonSingleNode(this.connectionManager, this.commandExecutor);
        }
        if (nodes.getClazz() == RedisCluster.class) {
            if (!this.config.isClusterConfig()) {
                throw new IllegalArgumentException("Can't be used in non Redis Cluster configuration");
            }
            return (T)new RedissonClusterNodes(this.connectionManager, this.commandExecutor);
        }
        if (nodes.getClazz() == RedisSentinelMasterSlave.class) {
            if (!this.config.isSentinelConfig()) {
                throw new IllegalArgumentException("Can't be used in non Redis Sentinel configuration");
            }
            return (T)new RedissonSentinelMasterSlaveNodes(this.connectionManager, this.commandExecutor);
        }
        if (nodes.getClazz() == RedisMasterSlave.class) {
            if (this.config.isSentinelConfig() || this.config.isClusterConfig()) {
                throw new IllegalArgumentException("Can't be used in non Redis Master Slave configuration");
            }
            return (T)new RedissonMasterSlaveNodes(this.connectionManager, this.commandExecutor);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public NodesGroup<Node> getNodesGroup() {
        return new RedisNodes<Node>(this.connectionManager, this.commandExecutor);
    }

    @Override
    public ClusterNodesGroup getClusterNodesGroup() {
        if (!this.connectionManager.isClusterMode()) {
            throw new IllegalStateException("Redisson is not in cluster mode!");
        }
        return new RedisClusterNodes(this.connectionManager, this.commandExecutor);
    }

    @Override
    public boolean isShutdown() {
        return this.connectionManager.isShutdown();
    }

    @Override
    public boolean isShuttingDown() {
        return this.connectionManager.isShuttingDown();
    }

    @Override
    public <V> RPriorityQueue<V> getPriorityQueue(String name) {
        return new RedissonPriorityQueue(this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityQueue<V> getPriorityQueue(String name, Codec codec) {
        return new RedissonPriorityQueue(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name) {
        return new RedissonPriorityBlockingQueue(this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name, Codec codec) {
        return new RedissonPriorityBlockingQueue(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name) {
        return new RedissonPriorityBlockingDeque(this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name, Codec codec) {
        return new RedissonPriorityBlockingDeque(codec, this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityDeque<V> getPriorityDeque(String name) {
        return new RedissonPriorityDeque(this.commandExecutor, name, this);
    }

    @Override
    public <V> RPriorityDeque<V> getPriorityDeque(String name, Codec codec) {
        return new RedissonPriorityDeque(codec, this.commandExecutor, name, this);
    }

    @Override
    public String getId() {
        return this.connectionManager.getId();
    }

    static {
        RedissonReference.warmUp();
    }
}

