/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.redisson.api.RFuture;
import org.redisson.connection.ConnectionManager;
import org.redisson.misc.RedissonPromise;

public class ElementsSubscribeService {
    private final Map<Integer, RFuture<?>> subscribeListeners = new HashMap();
    private final ConnectionManager connectionManager;

    public ElementsSubscribeService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> int subscribeOnElements(Supplier<RFuture<V>> func, Consumer<V> consumer) {
        int id = System.identityHashCode(consumer);
        Map<Integer, RFuture<?>> map = this.subscribeListeners;
        synchronized (map) {
            RFuture<Object> currentFuture = this.subscribeListeners.putIfAbsent(id, RedissonPromise.newSucceededFuture(null));
            if (currentFuture != null) {
                throw new IllegalArgumentException("Consumer object with listener id " + id + " already registered");
            }
        }
        this.resubscribe(func, consumer);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(int listenerId) {
        RFuture<?> f;
        Map<Integer, RFuture<?>> map = this.subscribeListeners;
        synchronized (map) {
            f = this.subscribeListeners.remove(listenerId);
        }
        if (f != null) {
            f.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void resubscribe(Supplier<RFuture<V>> func, Consumer<V> consumer) {
        RFuture<Object> f;
        int listenerId = System.identityHashCode(consumer);
        if (!this.subscribeListeners.containsKey(listenerId)) {
            return;
        }
        Map<Integer, RFuture<?>> map = this.subscribeListeners;
        synchronized (map) {
            if (!this.subscribeListeners.containsKey(listenerId)) {
                return;
            }
            f = func.get();
            this.subscribeListeners.put(listenerId, f);
        }
        f.onComplete((r, e) -> {
            if (e != null) {
                this.connectionManager.newTimeout(arg_0 -> this.lambda$resubscribe$0((Supplier)func, consumer, arg_0), 1L, TimeUnit.SECONDS);
                return;
            }
            consumer.accept(r);
            this.resubscribe(func, consumer);
        });
    }

    private /* synthetic */ void lambda$resubscribe$0(Supplier func, Consumer consumer, Timeout t) throws Exception {
        this.resubscribe(func, consumer);
    }
}

