/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.example.unicast;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AsyncSubscriber<T>
implements Subscriber<T>,
Runnable {
    private Subscription subscription;
    private boolean done;
    private final Executor executor;
    private final ConcurrentLinkedQueue<Signal> inboundSignals = new ConcurrentLinkedQueue();
    private final AtomicBoolean on = new AtomicBoolean(false);

    protected AsyncSubscriber(Executor executor) {
        if (executor == null) {
            throw null;
        }
        this.executor = executor;
    }

    private final void done() {
        this.done = true;
        if (this.subscription != null) {
            try {
                this.subscription.cancel();
            }
            catch (Throwable t) {
                new IllegalStateException(this.subscription + " violated the Reactive Streams rule 3.15 by throwing an exception from cancel.", t).printStackTrace(System.err);
            }
        }
    }

    protected abstract boolean whenNext(T var1);

    protected void whenComplete() {
    }

    protected void whenError(Throwable error) {
    }

    private final void handleOnSubscribe(Subscription s) {
        if (s != null) {
            if (this.subscription != null) {
                try {
                    s.cancel();
                }
                catch (Throwable t) {
                    new IllegalStateException(s + " violated the Reactive Streams rule 3.15 by throwing an exception from cancel.", t).printStackTrace(System.err);
                }
            } else {
                this.subscription = s;
                try {
                    s.request(1L);
                }
                catch (Throwable t) {
                    new IllegalStateException(s + " violated the Reactive Streams rule 3.16 by throwing an exception from request.", t).printStackTrace(System.err);
                }
            }
        }
    }

    private final void handleOnNext(T element) {
        if (!this.done) {
            if (this.subscription == null) {
                new IllegalStateException("Someone violated the Reactive Streams rule 1.09 and 2.1 by signalling OnNext before `Subscription.request`. (no Subscription)").printStackTrace(System.err);
            } else {
                try {
                    if (this.whenNext(element)) {
                        try {
                            this.subscription.request(1L);
                        }
                        catch (Throwable t) {
                            new IllegalStateException(this.subscription + " violated the Reactive Streams rule 3.16 by throwing an exception from request.", t).printStackTrace(System.err);
                        }
                    } else {
                        this.done();
                    }
                }
                catch (Throwable t) {
                    this.done();
                    try {
                        this.onError(t);
                    }
                    catch (Throwable t2) {
                        new IllegalStateException(this + " violated the Reactive Streams rule 2.13 by throwing an exception from onError.", t2).printStackTrace(System.err);
                    }
                }
            }
        }
    }

    private void handleOnComplete() {
        if (this.subscription == null) {
            new IllegalStateException("Publisher violated the Reactive Streams rule 1.09 signalling onComplete prior to onSubscribe.").printStackTrace(System.err);
        } else {
            this.done = true;
            this.whenComplete();
        }
    }

    private void handleOnError(Throwable error) {
        if (this.subscription == null) {
            new IllegalStateException("Publisher violated the Reactive Streams rule 1.09 signalling onError prior to onSubscribe.").printStackTrace(System.err);
        } else {
            this.done = true;
            this.whenError(error);
        }
    }

    public final void onSubscribe(Subscription s) {
        if (s == null) {
            throw null;
        }
        this.signal(new OnSubscribe(s));
    }

    public final void onNext(T element) {
        if (element == null) {
            throw null;
        }
        this.signal(new OnNext<T>(element));
    }

    public final void onError(Throwable t) {
        if (t == null) {
            throw null;
        }
        this.signal(new OnError(t));
    }

    public final void onComplete() {
        this.signal(OnComplete.Instance);
    }

    @Override
    public final void run() {
        if (this.on.get()) {
            try {
                Signal s = this.inboundSignals.poll();
                if (!this.done) {
                    if (s instanceof OnNext) {
                        this.handleOnNext(((OnNext)s).next);
                    } else if (s instanceof OnSubscribe) {
                        this.handleOnSubscribe(((OnSubscribe)s).subscription);
                    } else if (s instanceof OnError) {
                        this.handleOnError(((OnError)s).error);
                    } else if (s == OnComplete.Instance) {
                        this.handleOnComplete();
                    }
                }
            }
            finally {
                this.on.set(false);
                if (!this.inboundSignals.isEmpty()) {
                    this.tryScheduleToExecute();
                }
            }
        }
    }

    private void signal(Signal signal) {
        if (this.inboundSignals.offer(signal)) {
            this.tryScheduleToExecute();
        }
    }

    private final void tryScheduleToExecute() {
        block6: {
            if (this.on.compareAndSet(false, true)) {
                try {
                    this.executor.execute(this);
                }
                catch (Throwable t) {
                    if (this.done) break block6;
                    try {
                        this.done();
                    }
                    finally {
                        this.inboundSignals.clear();
                        this.on.set(false);
                    }
                }
            }
        }
    }

    private static class OnSubscribe
    implements Signal {
        public final Subscription subscription;

        public OnSubscribe(Subscription subscription) {
            this.subscription = subscription;
        }
    }

    private static class OnNext<T>
    implements Signal {
        public final T next;

        public OnNext(T next) {
            this.next = next;
        }
    }

    private static class OnError
    implements Signal {
        public final Throwable error;

        public OnError(Throwable error) {
            this.error = error;
        }
    }

    private static enum OnComplete implements Signal
    {
        Instance;

    }

    private static interface Signal {
    }
}

