/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.optional;

import org.rapidoid.RapidoidThing;
import org.rapidoid.u.U;

public final class Opt<E>
extends RapidoidThing {
    private final E value;

    private Opt(E value) {
        this.value = value;
    }

    public static <T> Opt<T> of(T value) {
        U.notNull(value, "value", new Object[0]);
        return new Opt<T>(value);
    }

    public static <T> Opt<T> maybe(T value) {
        return new Opt<T>(value);
    }

    public static <T> Opt<T> empty() {
        return new Opt<Object>(null);
    }

    public boolean exists() {
        return this.value != null;
    }

    public E get() {
        U.must(this.exists(), "The optional value doesn't exist!");
        return this.value;
    }

    public E orFail(String errMsg) {
        if (this.exists()) {
            return this.get();
        }
        throw U.rte(errMsg);
    }
}

