/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.Protocol;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.resolver.TupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.SequenceRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.utils.ConvertUtils;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class ProtocolRule
extends DefaultTupleRule<Node, Node>
implements SequenceRule {
    private static final DefaultScalarTupleHandler PROTOCOL_HANDLER = new DefaultScalarTupleHandler("protocols");
    protected Map<String, TupleRule<?, ?>> rules = new HashMap();

    @Override
    public TupleHandler getHandler() {
        return PROTOCOL_HANDLER;
    }

    @Override
    protected boolean isValidValueNodeType(Class valueNodeClass) {
        for (Class<?> clazz : this.getValueNodeType()) {
            if (!clazz.isAssignableFrom(valueNodeClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getValueNodeType() {
        return new Class[]{ScalarNode.class, SequenceNode.class};
    }

    @Override
    public NodeRule<?> getItemRule() {
        return this;
    }

    @Override
    public List<ValidationResult> doValidateValue(Node value) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (value instanceof ScalarNode && !ConvertUtils.canBeConverted(((ScalarNode)value).getValue(), Protocol.class)) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getRuleTypeMisMatch(this.getName(), Protocol.class.getSimpleName()), value));
        }
        return validationResults;
    }
}

