/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Log;
import quickfix.Session;
import quickfix.SessionID;

public class LogUtil {
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);

    public static void logThrowable(Log log, String message, Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        t.printStackTrace(printWriter);
        if (t.getCause() != null) {
            printWriter.println("Cause: " + t.getCause().getMessage());
            t.getCause().printStackTrace(printWriter);
        }
        log.onErrorEvent(stringWriter.toString());
    }

    public static void logThrowable(SessionID sessionID, String message, Throwable t) {
        Session session = Session.lookupSession(sessionID);
        if (session != null) {
            LogUtil.logThrowable(session.getLog(), message, t);
        } else {
            log.error(message, t);
        }
    }
}

