/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import javax.sql.DataSource;
import quickfix.JdbcStore;
import quickfix.MessageStore;
import quickfix.MessageStoreFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class JdbcStoreFactory
implements MessageStoreFactory {
    private final SessionSettings settings;
    private DataSource dataSource;

    public JdbcStoreFactory(SessionSettings settings) {
        this.settings = settings;
    }

    @Override
    public MessageStore create(SessionID sessionID) {
        try {
            return new JdbcStore(this.settings, sessionID, this.dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SessionSettings getSettings() {
        return this.settings;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

